/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support;

import com.ibm.bi.logging.glug.support.TransactionIdDigester;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BITransactionHeader
extends BasicHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BITransactionHeader.class);
    private static final long serialVersionUID = -5359515380565769488L;
    private String[] ids = null;
    private final String currentID = BITransactionHeader.generateTransactionID();
    private static final int root = 0;
    private static final int parent = 1;
    private static final int current = 2;

    public BITransactionHeader(String currentValue) {
        super("X-CA-Transaction", currentValue);
        this.init();
    }

    private void init() {
        this.ids = new String[3];
        HeaderElement[] currentElements = super.getElements();
        if (currentElements != null && currentElements.length == 3) {
            this.ids[0] = currentElements[0].getValue();
            this.ids[1] = currentElements[2].getValue();
        } else {
            this.ids[0] = this.currentID;
            this.ids[1] = "";
        }
        this.ids[2] = this.currentID;
        LOGGER.debug("new transaction header: {}", (Object)this.getValue());
    }

    public boolean isRootTransaction() {
        return this.ids[0].equals(this.ids[2]) || StringUtils.isEmpty((String)this.ids[1]);
    }

    public String getValue() {
        HeaderElement[] elements = this.getElements();
        return elements[0].toString() + ", " + elements[1].toString() + ", " + elements[2].toString();
    }

    public HeaderElement[] getElements() throws ParseException {
        return new HeaderElement[]{new BasicHeaderElement("rootId", this.ids[0]), new BasicHeaderElement("parentId", this.ids[1]), new BasicHeaderElement("currentId", this.ids[2])};
    }

    public static String generateTransactionID() {
        String currentId = "";
        String random = UUID.randomUUID().toString();
        try {
            TransactionIdDigester td = new TransactionIdDigester();
            currentId = td.getNextID(random);
            LOGGER.debug("currentId generated: {}", (Object)currentId);
        }
        catch (Exception e) {
            LOGGER.error("Fail to initialize transactionIdDigester", (Throwable)e);
        }
        return currentId;
    }

    public String getRootID() {
        return this.ids[0];
    }
}

