/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIdDigester {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionIdDigester.class);
    private static final char[] hex_chars = new char[]{'s', 'l', 'v', 'G', '9', 'q', 'w', '4', 'd', 'j', '2', 'h', 'y', '8', 'C', 'M'};
    private MessageDigest digester;
    private HackByteArrayOutputStream baos;
    private DataOutputStream daos;
    private StringBuilder sb;

    TransactionIdDigester() throws NoSuchAlgorithmException {
        try {
            this.digester = MessageDigest.getInstance("SHA");
            this.baos = new HackByteArrayOutputStream(256);
            this.daos = new DataOutputStream(this.baos);
            this.sb = new StringBuilder(40);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Fail to initialize transactionIdDigester, reason: No Such Algorithm");
            throw e;
        }
    }

    String getDigest() {
        this.digester.update(this.baos.getBytes(), 0, this.baos.getLength());
        byte[] bytes = this.digester.digest();
        this.hexify(bytes);
        return this.sb.toString();
    }

    private void hexify(byte[] bytes) {
        this.sb.setLength(0);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            this.sb.append(hex_chars[b & 0xF]).append(hex_chars[(b & 0xF0) >> 4]);
        }
    }

    public String getNextID(String random) {
        long seq = System.currentTimeMillis();
        long r = new Random().nextLong();
        TransactionIdDigester td = null;
        try {
            td = new TransactionIdDigester();
            if (random != null) {
                td.daos.write(random.getBytes());
            }
            td.daos.writeLong(seq);
            td.daos.writeLong(r);
            return td.getDigest();
        }
        catch (Exception x) {
            LOGGER.error("Fail to initialize transactionIdDigester", (Throwable)x);
            return null;
        }
    }

    private class HackByteArrayOutputStream
    extends ByteArrayOutputStream {
        HackByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        byte[] getBytes() {
            return this.buf;
        }

        public int getLength() {
            return this.count;
        }
    }
}

