/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support.web;

import com.ibm.bi.logging.glug.support.BITransactionHeader;
import com.ibm.bi.logging.glug.support.InvalidLoggingCookieException;
import com.ibm.bi.logging.glug.support.LoggingCookie;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class GlugLoggingContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlugLoggingContext.class);
    public static final String CAM_PASSPORT_COOKIE = "usersessionid";
    public static final String MDC_CAM_PASSPORT = "sessionId";
    public static final String MDC_LOGSESSION = "logSESSION";
    public static final String MDC_LOGSESSIONID = "logSESSIONID";
    public static final String MDC_CLIENTADDRESS = "clientAddress";
    public static final String MDC_CLIENTPORT = "clientPort";
    public static final String MDC_PATHINFO = "requestName";
    public static final String MDC_SERVLET_ID = "serviceName";
    public static final String MDC_PROCESSID = "processId";
    protected static final String CLEARED_IN_MDC = "{} cleared in MDC";
    private static final String UPDATE_IN_MDC = "update {}='{}' in MDC";

    public static void setupContext(HttpServletRequest req, MDCAdapter mdc) {
        try {
            GlugLoggingContext.setHttpRequestMDCVariables(mdc, req);
            GlugLoggingContext.clearUserMDCVariables(mdc);
            GlugLoggingContext.setUserMDCVariables(mdc, req);
            GlugLoggingContext.setLoggingControl(mdc, req);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("unable to set logging MDC properties {}", (Throwable)e);
        }
    }

    public static void clearContext(MDCAdapter mdc) {
        mdc.clear();
    }

    public static void clearContext() {
        GlugLoggingContext.clearContext(MDC.getMDCAdapter());
    }

    static void setLoggingControl(MDCAdapter mdc, HttpServletRequest req) {
        String loggingCookieValue = GlugLoggingContext.getCookieValue(req, "ba-logging-session");
        if (StringUtils.isEmpty((String)loggingCookieValue) || null == mdc) {
            return;
        }
        GlugLoggingContext.setupLoggingControl(mdc, loggingCookieValue);
    }

    public static void setupLoggingControl(MDCAdapter mdc, String loggingCookieValue) {
        try {
            LoggingCookie lc = LoggingCookie.parseCookie(loggingCookieValue);
            if (lc != null && !lc.isExpired()) {
                mdc.put(MDC_LOGSESSION, "enabled");
                mdc.put(MDC_LOGSESSIONID, lc.getSessionId());
                LOGGER.debug("session logging update {}='{}' in MDC", (Object)MDC_LOGSESSIONID, (Object)lc.getSessionId());
            } else {
                GlugLoggingContext.clearSessionLoggingMDCVariables(mdc);
            }
        }
        catch (InvalidLoggingCookieException e) {
            LOGGER.debug("received invalid logging cookie", (Throwable)e);
        }
    }

    public static void setupLoggingControl(String loggingCookieValue) {
        GlugLoggingContext.setupLoggingControl(MDC.getMDCAdapter(), loggingCookieValue);
    }

    static void setUserMDCVariables(MDCAdapter mdc, HttpServletRequest req) {
        String currentPassport = GlugLoggingContext.getCookieValue(req, CAM_PASSPORT_COOKIE);
        mdc.put(MDC_CAM_PASSPORT, currentPassport == null ? "NA" : currentPassport);
        LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_CAM_PASSPORT, (Object)currentPassport);
    }

    static void setHttpRequestMDCVariables(MDCAdapter mdc, HttpServletRequest req) {
        mdc.put(MDC_CLIENTADDRESS, req.getRemoteAddr());
        LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_CLIENTADDRESS, (Object)req.getRemoteAddr());
        mdc.put(MDC_CLIENTPORT, Integer.toString(req.getRemotePort()));
        LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_CLIENTPORT, (Object)req.getRemotePort());
        mdc.put(MDC_PATHINFO, req.getPathInfo());
        LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_PATHINFO, (Object)req.getPathInfo());
        ServletContext c = req.getServletContext();
        if (c != null) {
            mdc.put(MDC_SERVLET_ID, c.getServletContextName());
            LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_SERVLET_ID, (Object)c.getServletContextName());
        }
        mdc.put(MDC_PROCESSID, ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", ""));
        LOGGER.debug(UPDATE_IN_MDC, (Object)MDC_PROCESSID, (Object)ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", ""));
    }

    static void clearUserMDCVariables(MDCAdapter mdc) {
        mdc.remove(MDC_CAM_PASSPORT);
        LOGGER.debug(CLEARED_IN_MDC, (Object)MDC_CAM_PASSPORT);
        GlugLoggingContext.clearSessionLoggingMDCVariables(mdc);
    }

    static void clearSessionLoggingMDCVariables(MDCAdapter mdc) {
        if (null != mdc) {
            mdc.remove(MDC_LOGSESSION);
            mdc.remove(MDC_LOGSESSIONID);
            LOGGER.debug(CLEARED_IN_MDC, (Object)MDC_LOGSESSIONID);
        }
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        String cookieValue = null;
        if (null == request || null == cookieName) {
            return cookieValue;
        }
        Cookie[] cookies = request.getCookies();
        if (null == cookies) {
            return cookieValue;
        }
        for (Cookie aCookie : cookies) {
            if (!aCookie.getName().equalsIgnoreCase(cookieName)) continue;
            cookieValue = aCookie.getValue();
            break;
        }
        return cookieValue;
    }

    public static void setupLoggingTransactionIDs(MDCAdapter mdc, String caTransactionCookieValue) {
        BITransactionHeader header = new BITransactionHeader(GlugLoggingContext.urlDecode(caTransactionCookieValue));
        for (HeaderElement element : header.getElements()) {
            mdc.put(element.getName(), element.getValue());
        }
    }

    public static void setupLoggingTransactionIDs(String caTransactionCookieValue) {
        GlugLoggingContext.setupLoggingTransactionIDs(MDC.getMDCAdapter(), caTransactionCookieValue);
    }

    private static String urlDecode(String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

