/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model;

import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QuickAccessSmartsModule {
    private Map<String, ColumnIdentifier> idForExpressionMap;
    private Map<String, Map<String, ColumnIdentifier>> datasetMap;
    private Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> bivariates = new HashMap<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>>();
    private final SmartsModule smartsModule;
    private boolean indexed;

    public QuickAccessSmartsModule(SmartsModule smartsModule) {
        this.smartsModule = smartsModule;
    }

    public void maybeCreateIndices() {
        if (!this.indexed) {
            this.createIndices();
        }
    }

    private void createIndices() {
        this.idForExpressionMap = new HashMap<String, ColumnIdentifier>();
        this.datasetMap = new HashMap<String, Map<String, ColumnIdentifier>>();
        try {
            this.smartsModule.getDatasets().forEach(d -> {
                SmartsModuleUtil.getFlattenedColumns(d).forEach(c -> {
                    ColumnIdentifier columnIdentifier = new ColumnIdentifier((DatasetInfo)d, (ColumnInfo)c);
                    if (!StringUtils.isEmpty((CharSequence)c.getIdForExpression())) {
                        this.idForExpressionMap.put(c.getIdForExpression(), columnIdentifier);
                    }
                    this.datasetMap.putIfAbsent(d.getId(), new HashMap());
                    this.datasetMap.get(d.getId()).put(c.getId(), columnIdentifier);
                });
                d.getBivariateStatistics().forEach(bi -> this.storeBivariate((BivariateStatistics)bi, (DatasetInfo)d));
            });
        }
        finally {
            this.indexed = true;
        }
    }

    public void resetIndices() {
        this.indexed = false;
        this.createIndices();
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }

    public ColumnIdentifier getColumnIdentifier(String idForExpression) {
        this.maybeCreateIndices();
        return this.idForExpressionMap.get(idForExpression);
    }

    public ColumnIdentifier getColumnIdentifier(String datasetId, String columnId) {
        Map<String, ColumnIdentifier> columns = this.datasetMap.get(datasetId);
        return columns != null ? columns.get(columnId) : null;
    }

    public Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> getAllBivariates() {
        return this.bivariates;
    }

    public Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> getAllBivariatesByDatasetId(String datasetId) {
        if (this.bivariates.containsKey(datasetId)) {
            return this.bivariates.get(datasetId);
        }
        this.bivariates.put(datasetId, new HashMap());
        return this.bivariates.get(datasetId);
    }

    public Map<ColumnIdentifier, BivariateStatistics> getBivariates(ColumnInfo columnInfo) {
        return this.getBivariates(this.getColumnIdentifier(columnInfo.getIdForExpression()));
    }

    public Map<ColumnIdentifier, BivariateStatistics> getBivariates(ColumnIdentifier columnIdentifier) {
        return this.getAllBivariatesByDatasetId(columnIdentifier.datasetId).get(columnIdentifier);
    }

    public boolean hasBivariates(ColumnInfo columnInfo) {
        return this.hasBivariates(this.getColumnIdentifier(columnInfo.getIdForExpression()));
    }

    public boolean hasBivariates(ColumnIdentifier columnIdentifier) {
        return this.getAllBivariatesByDatasetId(columnIdentifier.datasetId).containsKey(columnIdentifier);
    }

    private void storeBivariate(BivariateStatistics bi, DatasetInfo ds) {
        ColumnIdentifier columnIdentifier1;
        Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> bivariatesByDataset = this.getAllBivariatesByDatasetId(ds.getId());
        if (!bivariatesByDataset.containsKey(columnIdentifier1 = this.getColumnIdentifier(ds.getId(), bi.getColumn1()))) {
            bivariatesByDataset.put(columnIdentifier1, new HashMap());
        }
        ColumnIdentifier columnIdentifier2 = this.getColumnIdentifier(ds.getId(), bi.getColumn2());
        Map<ColumnIdentifier, BivariateStatistics> storedMap = bivariatesByDataset.get(columnIdentifier1);
        storedMap.put(columnIdentifier2, bi);
        if (!bivariatesByDataset.containsKey(columnIdentifier2)) {
            bivariatesByDataset.put(columnIdentifier2, new HashMap());
        }
        Map<ColumnIdentifier, BivariateStatistics> storedMap2 = bivariatesByDataset.get(columnIdentifier2);
        storedMap2.put(columnIdentifier1, bi);
    }
}

