/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.datatype;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DecimalType;
import com.ibm.smarts.model.datatype.StringType;
import java.io.IOException;

public class DataTypeSerializer
extends StdSerializer<DataType> {
    private static final long serialVersionUID = -2722045722357684876L;

    DataTypeSerializer() {
        super(DataType.class);
    }

    protected DataTypeSerializer(Class<DataType> t) {
        super(t);
    }

    public void serializeWithType(DataType value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jgen, provider);
    }

    public void serialize(DataType value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("type", value.getBaseType().name().toLowerCase());
        switch (value.getBaseType()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)value;
                jgen.writeNumberField("precision", decimalType.getPrecision());
                jgen.writeNumberField("scale", decimalType.getScale());
                break;
            }
            case STRING: {
                StringType stringType = (StringType)value;
                jgen.writeNumberField("maxLength", stringType.getMaxLength());
                break;
            }
        }
        jgen.writeEndObject();
    }
}

