/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.stats;

import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueFactory;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;

public class StatisticsFactory {
    private static ObjectFactory objectFactory = new ObjectFactory();

    private StatisticsFactory() {
    }

    public static Statistic createCount(long count) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.COUNT);
        result.setValue(ValueFactory.createLong(count));
        return result;
    }

    public static Statistic createDensity(float density) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.DENSITY);
        result.setValue(ValueFactory.createFloat(density));
        return result;
    }

    public static Statistic createDistinctCount(long distinctCount) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.DISTINCT_COUNT);
        result.setValue(ValueFactory.createLong(distinctCount));
        return result;
    }

    public static Statistic createMaxValue(Value maxValue) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.MAX_VALUE);
        result.setValue(maxValue);
        return result;
    }

    public static Statistic createMinValue(Value minValue) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.MIN_VALUE);
        result.setValue(minValue);
        return result;
    }

    public static Statistic createNullCount(long nullCount) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.NULL_COUNT);
        result.setValue(ValueFactory.createLong(nullCount));
        return result;
    }

    public static Statistic createTotalCount(long totalCount) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.TOTAL_COUNT);
        result.setValue(ValueFactory.createLong(totalCount));
        return result;
    }

    public static Statistic createNullable(boolean nullable) {
        Statistic result = objectFactory.createStatistic();
        result.setType(StatisticType.NULLABLE);
        result.setValue(ValueFactory.createBoolean(nullable));
        return result;
    }
}

