/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.util.Date;

@JsonTypeName(value="boolean")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class BooleanValue
extends Value {
    @JsonProperty(value="booleanValue")
    private boolean value;

    public BooleanValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public BooleanValue(boolean value, ValueStatus status) {
        this.set(value, status);
    }

    public BooleanValue(boolean value) {
        this.set(value);
    }

    @JsonGetter(value="booleanValue")
    public boolean getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return DataTypes.getBooleanType();
    }

    public void set(boolean value, ValueStatus status) {
        this.value = value;
        this.setStatus(status);
    }

    public void set(boolean value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Boolean value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.value;
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.intValue();
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return Boolean.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return new BigDecimal(this.intValue());
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return DELINQUENT_DATE;
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.getStatus().hashCode() + this.intValue();
    }

    @Override
    public int compareTo(Value other) {
        int rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.BOOLEAN) {
            return BooleanValue.compareValue(this, other);
        }
        int c = BooleanValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        int leftValue = this.intValue();
        if (leftValue < (rightValue = other.intValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(value.booleanValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(Boolean.parseBoolean(value), ValueStatus.OK);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BooleanValue that = (BooleanValue)o;
        return this.value == that.value;
    }
}

