/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.DateTimeValue;
import com.ibm.smarts.model.value.DateValueDeserializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonTypeName(value="date")
@JsonDeserialize(using=DateValueDeserializer.class)
public class DateValue
extends DateTimeValue {
    private static final Pattern PATTERN = Pattern.compile("[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+");

    public DateValue() {
    }

    public DateValue(TimeZone tz) {
        super(tz);
    }

    public DateValue(Date dt) {
        super(dt);
        this.clearTimeFields();
    }

    public DateValue(Date dt, TimeZone tz) {
        super(dt, tz);
        this.clearTimeFields();
    }

    public DateValue(Calendar cal) {
        super(cal);
        this.clearTimeFields();
    }

    @Override
    public DataType getType() {
        return DataTypes.getDateType();
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set((Date)null, ValueStatus.NULL);
            return;
        }
        Matcher m = PATTERN.matcher(value);
        if (!m.matches()) {
            this.set((Date)null, ValueStatus.ERROR);
            return;
        }
        String[] dateFields = value.split("-");
        int year = Integer.parseInt(dateFields[0]);
        int month = Integer.parseInt(dateFields[1]);
        int day = Integer.parseInt(dateFields[2]);
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.clearTimeFields();
        this.setOK();
    }

    @Override
    public void set(Date dt, TimeZone tz, ValueStatus status) {
        super.set(dt, tz, status);
        this.clearTimeFields();
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return String.format("%1$4d-%2$02d-%3$02d", this.getYear(), this.getMonth(), this.getDay());
    }

    @Override
    public String stringValueISO8601NoTimezone() {
        if (!this.isOK()) {
            return null;
        }
        return String.format("%1$4d-%2$02d-%3$02d", this.getYear(), this.getMonth(), this.getDay());
    }
}

