/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.datatype.DecimalType;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;

@JsonTypeName(value="decimal")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class DecimalValue
extends Value {
    private final DecimalType mType;
    @JsonProperty(value="decimalValue")
    private BigDecimal value;

    public DecimalValue() {
        this(DataTypes.getDecimalType());
    }

    public DecimalValue(DecimalType type) {
        this.mType = type;
        this.setStatus(ValueStatus.NULL);
    }

    public DecimalValue(BigDecimal value) {
        if (null == value) {
            this.mType = DataTypes.getDecimalType();
            this.set(null);
        } else {
            this.mType = DataTypes.getDecimalType(Math.max(value.precision(), value.scale()), value.scale());
            this.set(value);
        }
    }

    public DecimalValue(DecimalType type, BigDecimal value) {
        this.mType = type;
        this.set(value);
    }

    @JsonGetter(value="decimalValue")
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return this.mType;
    }

    public void set(BigDecimal value, ValueStatus status) {
        this.value = null == value ? null : DecimalValue.cast(value, this.mType.getPrecision(), this.mType.getScale(), RoundingMode.HALF_DOWN);
        this.setStatus(status);
    }

    public void set(BigDecimal value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.value.toPlainString();
    }

    @Override
    public float floatValue() {
        if (!this.isOK() || null == this.value) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        if (!this.isOK() || null == this.value) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.value) {
            return DecimalValue.cast(BigDecimal.ZERO, this.mType.getPrecision(), this.mType.getScale(), RoundingMode.HALF_DOWN);
        }
        return this.value;
    }

    @Override
    public short shortValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        return this.value.shortValue();
    }

    @Override
    public byte byteValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        return this.value.byteValue();
    }

    @Override
    public int intValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (!this.isOK() || null == this.value) {
            return 0L;
        }
        return this.value.longValue();
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        return 0 != this.intValue();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hc = this.getStatus().hashCode();
        if (null != this.value) {
            hc = this.value.hashCode();
        }
        return hc;
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.DECIMAL) {
            return DecimalValue.compareValue(this, other);
        }
        int c = DecimalValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        BigDecimal leftValue = this.bigDecimalValue();
        BigDecimal rightValue = other.bigDecimalValue();
        if (null == leftValue) {
            if (null == rightValue) {
                return 0;
            }
            return -1;
        }
        if (null == rightValue) {
            return 1;
        }
        return leftValue.compareTo(rightValue);
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value.bigDecimalValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            try {
                this.set(new BigDecimal(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public Number numberValue() {
        return this.bigDecimalValue();
    }

    protected static BigDecimal cast(BigDecimal aBigDecimal, int newPrecision, int newScale, RoundingMode roundingMode) {
        int scale = aBigDecimal.scale();
        int precision = aBigDecimal.precision();
        if (precision == newPrecision && scale == newScale) {
            return aBigDecimal;
        }
        if (precision == newPrecision) {
            return aBigDecimal.setScale(newScale, roundingMode);
        }
        BigDecimal newValue = new BigDecimal(aBigDecimal.unscaledValue(), scale, new MathContext(newPrecision));
        if (scale == newScale) {
            return newValue;
        }
        return newValue.setScale(newScale, roundingMode);
    }
}

