/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.util.Date;

@JsonTypeName(value="long")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class LongValue
extends Value {
    @JsonProperty(value="longValue")
    private long value;

    public LongValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public LongValue(long value, ValueStatus status) {
        this.set(value, status);
    }

    public LongValue(long value) {
        this.set(value);
    }

    @JsonGetter(value="longValue")
    public long getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return DataTypes.getLongType();
    }

    public void set(long value, ValueStatus status) {
        this.value = value;
        this.setStatus(status);
    }

    public void set(long value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Long value) {
        if (null == value) {
            this.set(0L, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public float floatValue() {
        if (!this.isOK()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public double doubleValue() {
        if (!this.isOK()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public short shortValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public byte byteValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (int)this.value;
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return 0L != this.value;
    }

    @Override
    public int hashCode() {
        return this.getStatus().hashCode() + (int)this.value;
    }

    @Override
    public int compareTo(Value other) {
        long rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.LONG) {
            return LongValue.compareValue(this, other);
        }
        int c = LongValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        long leftValue = this.longValue();
        if (leftValue < (rightValue = other.longValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(0L, ValueStatus.NULL);
        } else {
            this.set(value.longValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(0L, ValueStatus.NULL);
        } else {
            try {
                this.set(Long.parseLong(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.longValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongValue longValue = (LongValue)o;
        return this.value == longValue.value;
    }
}

