/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.datatype.StringType;
import com.ibm.smarts.model.value.DateTimeValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueFactory;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;

@JsonTypeName(value="string")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class StringValue
extends Value {
    private StringType mType;
    @JsonProperty(value="stringValue")
    private String value;

    public StringValue() {
        this.mType = DataTypes.getStringType(1);
        this.setStatus(ValueStatus.NULL);
    }

    public StringValue(StringType type) {
        this.mType = type;
        this.setStatus(ValueStatus.NULL);
    }

    public StringValue(String value, ValueStatus status) {
        this.value = value;
        this.mType = null != value ? DataTypes.getStringType(Math.max(1, value.length())) : DataTypes.getStringType(1);
        this.setStatus(status);
    }

    public StringValue(String value) {
        this.value = value;
        if (null != value) {
            this.mType = DataTypes.getStringType(Math.max(1, value.length()));
            this.setStatus(ValueStatus.OK);
        } else {
            this.mType = DataTypes.getStringType(1);
            this.setStatus(ValueStatus.NULL);
        }
    }

    public StringValue(StringType type, String value, ValueStatus status) {
        this.value = value;
        this.mType = type;
        this.setStatus(status);
    }

    public StringValue(StringType type, String value) {
        this.value = value;
        this.mType = type;
        if (null == value) {
            this.setStatus(ValueStatus.NULL);
        } else {
            this.setStatus(ValueStatus.OK);
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return this.mType;
    }

    public void set(String value, ValueStatus status) {
        if (null != value && value.length() > this.mType.getMaxLength()) {
            this.mType = this.mType.withMaxLength(Math.max(1, value.length()));
        }
        this.value = value;
        this.setStatus(status);
    }

    public void set(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Number numberValue() {
        if (!this.isOK() || null == this.value) {
            return null;
        }
        try {
            return DecimalFormat.getInstance().parse(this.value);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    @JsonGetter(value="stringValue")
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.value) {
            return "null";
        }
        return this.value;
    }

    @Override
    public float floatValue() {
        if (!this.isOK() || null == this.value) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.value);
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    @Override
    public double doubleValue() {
        if (!this.isOK() || null == this.value) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.value);
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.value) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(this.value);
        }
        catch (Exception ex) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public short shortValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        try {
            return Short.parseShort(this.value);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public byte byteValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        try {
            return Byte.parseByte(this.value);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int intValue() {
        if (!this.isOK() || null == this.value) {
            return 0;
        }
        try {
            return Integer.parseInt(this.value);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public long longValue() {
        if (!this.isOK() || null == this.value) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.value) {
            return DELINQUENT_DATE;
        }
        DateTimeValue v = ValueFactory.createTimestamp();
        ((Value)v).assignFrom(this.value);
        if (v.isOK()) {
            return ((Value)v).dateValue();
        }
        v = ValueFactory.createDate();
        ((Value)v).assignFrom(this.value);
        if (v.isOK()) {
            return ((Value)v).dateValue();
        }
        v = ValueFactory.createTime();
        ((Value)v).assignFrom(this.value);
        if (v.isOK()) {
            return ((Value)v).dateValue();
        }
        return DELINQUENT_DATE;
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK() || null == this.value) {
            return false;
        }
        String temp = this.value.toLowerCase();
        return "true".equals(temp) || "yes".equals(temp);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringValue other = (StringValue)obj;
        if (this.getStatus() == null ? other.getStatus() != null : !this.getStatus().equals((Object)other.getStatus())) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.STRING) {
            return StringValue.compareValue(this, other);
        }
        int c = StringValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        String leftValue = this.stringValue();
        String rightValue = other.stringValue();
        if (null == leftValue) {
            if (null == rightValue) {
                return 0;
            }
            return -1;
        }
        if (null == rightValue) {
            return 1;
        }
        return leftValue.compareTo(rightValue);
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value.stringValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }
}

