/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.DateTimeValue;
import com.ibm.smarts.model.value.TimeValueDeserializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonTypeName(value="time")
@JsonDeserialize(using=TimeValueDeserializer.class)
public class TimeValue
extends DateTimeValue {
    private static final Pattern PATTERN = Pattern.compile("[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?((\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?)?");

    public TimeValue() {
    }

    public TimeValue(TimeZone tz) {
        super(tz);
    }

    public TimeValue(Date dt) {
        super(dt);
    }

    public TimeValue(Date dt, TimeZone tz) {
        super(dt, tz);
    }

    public TimeValue(Calendar cal) {
        super(cal);
    }

    @Override
    public DataType getType() {
        return DataTypes.getTimeType();
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set((Date)null, ValueStatus.NULL);
            return;
        }
        Matcher m = PATTERN.matcher(value);
        if (!m.matches() && !m.matches()) {
            this.set((Date)null, ValueStatus.ERROR);
            return;
        }
        int sign = 1;
        if (value.indexOf("-") > 0) {
            sign = -1;
        }
        String[] list = value.split("\\+|-");
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split("\\.");
        int second = Integer.parseInt(timeFields[0]);
        int nanoseconds = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        }
        if (list.length > 1) {
            String[] timeZoneFields = list[1].split(":");
            int tzHour = Integer.parseInt(timeZoneFields[0]);
            int tzMinute = 0;
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
            int rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
            this.setTimeZone(TimeValue.getTimeZoneFromRawOffset(rawOffset));
        }
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(nanoseconds / 1000000);
        this.setOK();
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getMillisecond() > 0) {
            sb.append(String.format("%1$02d:%2$02d:%3$02d.%4$09d", this.getHour(), this.getMinute(), this.getSecond(), 1000000 * this.getMillisecond()));
        } else {
            sb.append(String.format("%1$02d:%2$02d:%3$02d", this.getHour(), this.getMinute(), this.getSecond()));
        }
        sb.append(this.convertTimeZoneToString());
        return sb.toString();
    }

    @Override
    public String stringValueISO8601NoTimezone() {
        if (!this.isOK()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getMillisecond() > 0) {
            sb.append(String.format("%1$02d:%2$02d:%3$02d.%4$03d", this.getHour(), this.getMinute(), this.getSecond(), 1000000 * this.getMillisecond()));
        } else {
            sb.append(String.format("%1$02d:%2$02d:%3$02d", this.getHour(), this.getMinute(), this.getSecond()));
        }
        return sb.toString();
    }
}

