/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value.decor;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.icu.util.Currency;
import com.ibm.smarts.model.value.decor.CurrencyDecorationDeserializer;
import com.ibm.smarts.model.value.decor.CurrencyDecorationSerializer;
import com.ibm.smarts.model.value.decor.CurrencyDeserializer;
import com.ibm.smarts.model.value.decor.CurrencySerializer;
import com.ibm.smarts.model.value.decor.DecorationType;
import com.ibm.smarts.model.value.decor.ValueDecoration;

@JsonSerialize(using=CurrencyDecorationSerializer.class)
@JsonDeserialize(using=CurrencyDecorationDeserializer.class)
public final class CurrencyDecoration
extends ValueDecoration {
    public static final String NAME = "CurrencyDecoration";
    public static final String FORMAT = "CurrencyDecoration(%s)";
    @JsonSerialize(using=CurrencySerializer.class)
    @JsonDeserialize(using=CurrencyDeserializer.class)
    private Currency currency;

    public CurrencyDecoration(Currency currency) {
        if (null == currency) {
            throw new NullPointerException("currency was null");
        }
        this.currency = currency;
    }

    CurrencyDecoration() {
    }

    @Override
    public DecorationType getType() {
        return DecorationType.CURRENCY;
    }

    @Override
    public boolean isCurrency() {
        return true;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String toString() {
        return String.format(FORMAT, this.currency.getCurrencyCode());
    }

    public int hashCode() {
        return this.getType().hashCode() + this.currency.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrencyDecoration)) {
            return false;
        }
        CurrencyDecoration other = (CurrencyDecoration)o;
        return this.currency.equals((Object)other.currency);
    }
}

