/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value.decor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.value.decor.DecorationType;
import com.ibm.smarts.model.value.decor.OrderedDecorationDeserializer;
import com.ibm.smarts.model.value.decor.OrderedDecorationSerializer;
import com.ibm.smarts.model.value.decor.ValueDecoration;

@JsonSerialize(using=OrderedDecorationSerializer.class)
@JsonDeserialize(using=OrderedDecorationDeserializer.class)
public class OrderedDecoration
extends ValueDecoration {
    public static final String NAME = "OrderedDecoration";
    public static final String FORMAT = "OrderedDecoration(%s)";
    @JsonProperty(value="ascending")
    private final boolean ascending;

    public OrderedDecoration(boolean ascending) {
        this.ascending = ascending;
    }

    OrderedDecoration() {
        this.ascending = false;
    }

    @Override
    public DecorationType getType() {
        return DecorationType.ORDERED;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    public String toString() {
        return String.format(FORMAT, this.ascending ? "ascending" : "descending");
    }

    public int hashCode() {
        return this.getType().hashCode() + Boolean.hashCode(this.ascending);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderedDecoration)) {
            return false;
        }
        OrderedDecoration other = (OrderedDecoration)o;
        return this.ascending == other.ascending;
    }
}

