/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder<T> {
    private T instance;
    private static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);

    public Builder(Class<T> clazz) {
        try {
            this.instance = clazz.newInstance();
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Builder<T> with(Consumer<T> setter) {
        setter.accept(this.instance);
        return this;
    }

    public T build() {
        return this.instance;
    }

    public static <T> Builder<T> create(Class<T> clazz) {
        return new Builder<T>(clazz);
    }
}

