/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;

public class ColumnInfoUtil {
    private ColumnInfoUtil() {
    }

    public static ConceptInfo getConceptInfo(ColumnInfo column, String conceptId) {
        return column.getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals(conceptId)).findFirst().orElse(null);
    }

    public static Long getDistinctCount(ColumnInfo column) {
        Statistic distinctCount = ColumnInfoUtil.getStatistic(column, StatisticType.DISTINCT_COUNT);
        if (distinctCount != null && distinctCount.getValue() != null) {
            return distinctCount.getValue().longValue();
        }
        return null;
    }

    public static Long getCount(ColumnInfo column) {
        Statistic distinctCount = ColumnInfoUtil.getStatistic(column, StatisticType.COUNT);
        if (distinctCount != null && distinctCount.getValue() != null) {
            return distinctCount.getValue().longValue();
        }
        return null;
    }

    private static Statistic getStatistic(ColumnInfo column, StatisticType statType) {
        return column.getStatistics().stream().filter(stat -> stat.getType() == statType).findFirst().orElse(null);
    }
}

