/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;

public class JAXBHelper {
    private static final ConcurrentHashMap<String, JAXBContext> CACHE = new ConcurrentHashMap();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper JAXBANNOTATION_MAPPER = new ObjectMapper();

    public static <T> String marshalToJSON(T obj) throws IOException {
        return JAXBHelper.marshalToJSON(obj, false);
    }

    public static <T> String marshalToJSON(T obj, boolean pretty) throws IOException {
        if (pretty) {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        return MAPPER.writeValueAsString(obj);
    }

    public static <T> String marshalJaxbAnnotatedObjectToJSON(T obj, boolean pretty) throws IOException {
        if (pretty) {
            return JAXBANNOTATION_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        return JAXBANNOTATION_MAPPER.writeValueAsString(obj);
    }

    public static <T> String marshalAllToJSON(T obj, boolean pretty) throws IOException {
        ObjectMapper map = new ObjectMapper();
        map.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        if (pretty) {
            return map.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        return map.writeValueAsString(obj);
    }

    public static <T> void marshalAllToJSON(T obj, String fileName, boolean pretty) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        if (pretty) {
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(fileName), obj);
        } else {
            mapper.writeValue(new File(fileName), obj);
        }
    }

    public static <T> T unmarshalFromJSON(Class<T> clazz, String jsonSource) throws IOException {
        Object obj = MAPPER.readValue(jsonSource, clazz);
        if (obj instanceof SmartsModule) {
            SmartsModuleUtil.migrate((SmartsModule)obj);
        }
        return (T)obj;
    }

    public static <T> T unmarshalJaxbAnnotatedObjectFromJSON(Class<T> clazz, String jsonSource) throws IOException {
        Object obj = JAXBANNOTATION_MAPPER.readValue(jsonSource, clazz);
        if (obj instanceof SmartsModule) {
            SmartsModuleUtil.migrate((SmartsModule)obj);
        }
        return (T)obj;
    }

    public static <T> T unmarshalFromJSON(Class<T> clazz, InputStream jsonSource) throws IOException {
        Object obj = MAPPER.readValue(jsonSource, clazz);
        if (obj instanceof SmartsModule) {
            SmartsModuleUtil.migrate((SmartsModule)obj);
        }
        return (T)obj;
    }

    public static <T> List<T> unmarshalListFromJSON(Class<T> clazz, String jsonSource) throws IOException {
        CollectionType ct = MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
        List objects = (List)MAPPER.readValue(jsonSource, (JavaType)ct);
        if (!objects.isEmpty() && objects.get(0) instanceof SmartsModule) {
            SmartsModuleUtil.migrate(objects);
        }
        return objects;
    }

    public static <T> T unmarshalFromXML(Class<T> clazz, InputStream xmlSource) throws JAXBException {
        Object obj = JAXBHelper.getJAXBContext(clazz.getPackage().getName()).createUnmarshaller().unmarshal(xmlSource);
        if (obj instanceof SmartsModule) {
            SmartsModuleUtil.migrate((SmartsModule)obj);
        }
        return (T)obj;
    }

    public static <T> void marshalToXML(Class<T> clazz, T obj, OutputStream os) throws JAXBException {
        JAXBHelper.getJAXBContext(clazz.getPackage().getName()).createMarshaller().marshal(obj, os);
    }

    public static <T> JsonNode toJsonNode(T obj) {
        return MAPPER.valueToTree(obj);
    }

    public static <T> T parseJson(Class<T> klass, JsonNode jn) throws IOException {
        Object obj = MAPPER.treeToValue((TreeNode)jn, klass);
        if (obj instanceof SmartsModule) {
            SmartsModuleUtil.migrate((SmartsModule)obj);
        }
        return (T)obj;
    }

    public static JsonNode toJsonNode(String json) throws IOException {
        return MAPPER.readTree(json);
    }

    private static JAXBContext getJAXBContext(String packageName) throws JAXBException {
        JAXBContext jc = CACHE.get(packageName);
        if (null == jc) {
            jc = JAXBContext.newInstance((String)packageName);
            CACHE.put(packageName, jc);
        }
        return jc;
    }

    public static <T> void marshalToJSON(T obj, OutputStream jsonOut) throws IOException {
        JAXBHelper.marshalToJSON(obj, jsonOut, false);
    }

    public static <T> void marshalToJSON(T obj, OutputStream jsonOut, boolean pretty) throws IOException {
        if (pretty) {
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(jsonOut, obj);
        } else {
            MAPPER.writeValue(jsonOut, obj);
        }
    }

    public static boolean isEquivalentJSONString(String json1, String json2) throws IOException {
        if (json1 == null || json2 == null || StringUtils.isBlank((CharSequence)json1) || StringUtils.isBlank((CharSequence)json2)) {
            throw new IllegalArgumentException("Input cannot be null or blank");
        }
        return MAPPER.readTree(json1).equals((Object)MAPPER.readTree(json2));
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JAXBANNOTATION_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JAXBANNOTATION_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JAXBANNOTATION_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JAXBANNOTATION_MAPPER.registerModule((Module)new JaxbAnnotationModule());
    }
}

