/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.List;
import java.util.stream.Collectors;

public class SmartsUtil {
    public static final String SMARTSMODULE = "SmartsModule";
    public static final String SEMANTICINFO = "-SemanticInfo";
    private static final int FAILED_MASK = 1;
    private static final int DONE_MASK = 2;
    private static final int CANCELED_MASK = 4;
    private static final int IN_PROGRESS_MASK = 8;

    private SmartsUtil() {
    }

    public static SmartsModule smartsModulePartFrom(SmartsModule smarts, DatasetInfo datasetInfo) {
        SmartsModule smartsModulePart = SmartsModuleFactory.createSmartsModule();
        smartsModulePart.setId(smarts.getId());
        smartsModulePart.setDescription(smarts.getDescription());
        smartsModulePart.setComment(smarts.getComment());
        smartsModulePart.setName(smarts.getName());
        smartsModulePart.setLocale(smarts.getLocale());
        smartsModulePart.setType(smarts.getType());
        smartsModulePart.getDatasets().add(datasetInfo);
        smartsModulePart.setModuleLastModifiedTime(smarts.getModuleLastModifiedTime());
        smartsModulePart.setModuleCreationTime(smarts.getModuleCreationTime());
        smartsModulePart.setAnalysisMode(smarts.getAnalysisMode());
        smartsModulePart.setAnalysisState(smarts.getAnalysisState());
        return smartsModulePart;
    }

    public static SmartsModule smartsModuleFromParts(List<SmartsModule> parts) {
        SmartsModule smartsModule = SmartsModuleFactory.createSmartsModule();
        parts.stream().forEach(part -> {
            if (part != null) {
                smartsModule.setId(part.getId());
                smartsModule.setDescription(part.getDescription());
                smartsModule.setName(part.getName());
                smartsModule.setComment(part.getComment());
                smartsModule.setLocale(part.getLocale());
                smartsModule.setType(part.getType());
                smartsModule.getDatasets().addAll(part.getDatasets());
            }
        });
        return smartsModule;
    }

    public static SmartsModule smartsModuleFromParts(List<SmartsModule> parts, SmartsModule smartsModule, boolean clearDatasets) {
        if (clearDatasets) {
            smartsModule.getDatasets().clear();
        }
        parts.stream().forEach(part -> {
            if (part != null) {
                smartsModule.getDatasets().addAll(part.getDatasets());
            }
        });
        return smartsModule;
    }

    public static SmartsModule createMasterSmartsModule(SmartsModule smartsModule) {
        SmartsModule masterSmartsModule = SmartsModuleFactory.createSmartsModule();
        SmartsUtil.setSmartsModuleProperties(masterSmartsModule, smartsModule);
        masterSmartsModule.getDatasets().addAll(smartsModule.getDatasets().stream().map(ds -> {
            DatasetInfo newDs = SmartsModuleFactory.createDataset();
            newDs.setId(ds.getId());
            newDs.setIdForExpression(ds.getIdForExpression());
            newDs.getAnalysisPhases().addAll(ds.getAnalysisPhases());
            return newDs;
        }).collect(Collectors.toList()));
        return masterSmartsModule;
    }

    public static void setSmartsModuleProperties(SmartsModule destSmartsModule, SmartsModule srcSmartsModule) {
        destSmartsModule.setId(srcSmartsModule.getId());
        destSmartsModule.setDescription(srcSmartsModule.getDescription());
        destSmartsModule.setComment(srcSmartsModule.getComment());
        destSmartsModule.setName(srcSmartsModule.getName());
        destSmartsModule.setLocale(srcSmartsModule.getLocale());
        destSmartsModule.setType(srcSmartsModule.getType());
        destSmartsModule.setModuleLastModifiedTime(srcSmartsModule.getModuleLastModifiedTime());
        destSmartsModule.setModuleCreationTime(srcSmartsModule.getModuleCreationTime());
        destSmartsModule.setAnalysisMode(srcSmartsModule.getAnalysisMode());
        destSmartsModule.setAnalysisState(srcSmartsModule.getAnalysisState());
    }

    private static ColumnInfo getColumnInfoById(DatasetInfo ds, String columnId) {
        for (ColumnInfo col : SmartsModuleUtil.getFlattenedColumns(ds)) {
            if (!col.getId().equals(columnId)) continue;
            return col;
        }
        return null;
    }

    private static ColumnInfo getColumnInfoByIdForExpression(DatasetInfo ds, String columnIdForExpression) {
        for (ColumnInfo col : SmartsModuleUtil.getFlattenedColumns(ds)) {
            if (!col.getIdForExpression().equals(columnIdForExpression)) continue;
            return col;
        }
        return null;
    }

    public static ColumnInfo getColumnInfo(SmartsModule smarts, String datasetId, String columnId) {
        DatasetInfo namedSets;
        if ("_global_calculations".equals(datasetId)) {
            DatasetInfo calculations = smarts.getCalculations();
            if (calculations != null) {
                return SmartsUtil.getColumnInfoById(calculations, columnId);
            }
        } else if ("_global_namedSets".equals(datasetId) && (namedSets = smarts.getNamedSets()) != null) {
            return SmartsUtil.getColumnInfoById(namedSets, columnId);
        }
        for (DatasetInfo set : smarts.getDatasets()) {
            if (!set.getId().equals(datasetId)) continue;
            return SmartsUtil.getColumnInfoById(set, columnId);
        }
        return null;
    }

    public static ColumnInfo getColumnInfoByIdForExpression(SmartsModule smarts, String columnIdForExpression) {
        ColumnInfo col;
        for (DatasetInfo set : smarts.getDatasets()) {
            col = SmartsUtil.getColumnInfoByIdForExpression(set, columnIdForExpression);
            if (col == null) continue;
            return col;
        }
        col = SmartsUtil.getColumnInfoByIdForExpression(smarts.getCalculations(), columnIdForExpression);
        if (col != null) {
            return col;
        }
        col = SmartsUtil.getColumnInfoByIdForExpression(smarts.getNamedSets(), columnIdForExpression);
        return col;
    }

    public static AnalysisStateType calculateState(SmartsModule module) {
        int result = 0;
        for (DatasetInfo dataset : module.getDatasets()) {
            result |= SmartsUtil.calculateState(dataset);
        }
        if (module.getCalculations() != null) {
            result |= SmartsUtil.calculateState(module.getCalculations());
        }
        if (module.getNamedSets() != null) {
            result |= SmartsUtil.calculateState(module.getNamedSets());
        }
        if (result == 1) {
            return AnalysisStateType.FAILED;
        }
        if (result == 2) {
            return AnalysisStateType.DONE;
        }
        if (result == 4) {
            return AnalysisStateType.CANCELED;
        }
        if (result == 8) {
            return AnalysisStateType.IN_PROGRESS;
        }
        if ((result & 2) == 0) {
            if ((result & 1) == 1) {
                return AnalysisStateType.FAILED;
            }
            if ((result & 4) == 4) {
                return AnalysisStateType.CANCELED;
            }
            if ((result & 8) == 8) {
                return AnalysisStateType.IN_PROGRESS;
            }
        }
        return AnalysisStateType.PARTIAL;
    }

    private static int calculateState(DatasetInfo dataset) {
        int result = 0;
        List<AnalysisPhase> phases = dataset.getAnalysisPhases();
        for (AnalysisPhase phase : phases) {
            if (phase.getAnalysisState().equals((Object)AnalysisStateType.DONE)) {
                result |= 2;
                continue;
            }
            if (phase.getAnalysisState().equals((Object)AnalysisStateType.FAILED)) {
                result |= 1;
                continue;
            }
            if (phase.getAnalysisState().equals((Object)AnalysisStateType.CANCELED)) {
                result |= 4;
                continue;
            }
            if (!phase.getAnalysisState().equals((Object)AnalysisStateType.IN_PROGRESS)) continue;
            result |= 8;
        }
        return result;
    }
}

