/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js;

import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.JobService_PortType;
import com.cognos.developer.schemas.bibus._3.MonitorOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.js.JSCategory;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.js.impl.JobBuilder;
import com.cognos.js.impl.JobRunManager;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.service.ServiceImplBase;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.jsmcommon.util.UserAccountUtil;
import java.rmi.RemoteException;

public class JobServiceBinding
extends ServiceImplBase
implements JobService_PortType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            UserAccountUtil uau = new UserAccountUtil(headers);
            String userName = uau.getUserName();
            Object ctxObj = this.getContextObject();
            if (ctxObj != null && ctxObj instanceof IJob) {
                JobRunManager.instance().cancel(((IJob)ctxObj).getID(), userName);
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void release(AsynchRequest conversation) throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        AsynchReply reply;
        block14: {
            PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
            reply = null;
            try {
                BiBusHeader header = this.extractBiBusHeader();
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                JobBiBusHeaders headers = new JobBiBusHeaders(header);
                this.authenticate(headers);
                AsynchOption runContext = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext);
                if (runContext == null) {
                    MonitorServiceClientPort service = null;
                    try {
                        service = Client.instance().getMonitorServiceClient(headers);
                        MonitorOptionBoolean background = new MonitorOptionBoolean();
                        background.setName(MonitorOptionEnum.background);
                        background.setValue(true);
                        Option[] newOptions = null;
                        if (options != null) {
                            int optionsLength = options.length;
                            newOptions = new Option[optionsLength + 1];
                            System.arraycopy(options, 0, newOptions, 0, optionsLength);
                            newOptions[optionsLength] = background;
                        } else {
                            newOptions = new Option[]{background};
                        }
                        reply = service.run(objectPath, parameterValues, newOptions);
                        AsyncConversation conversation = new AsyncConversation();
                        reply = conversation.doConversationWithRelease((ServiceAPI)service, reply);
                        this.debugWait("primary.wait.js");
                        break block14;
                    }
                    catch (EMFSecurityException e) {
                        SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Security Error when running Job [" + objectPath.toString() + "].");
                        SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e.getLocalizedMessage());
                        throw new JobServiceException(I18NCode.JS_SUBMIT_ERROR);
                    }
                    finally {
                        if (service != null) {
                            service.close();
                        }
                    }
                }
                IJob job = JobBuilder.getJob(objectPath, headers, parameterValues, options);
                this.setContextObject(job);
                reply = JobRunManager.instance().run(job);
            }
            catch (LocalizableException e) {
                SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.ERROR, e);
                this.throwAxisFault(new APIException(e));
            }
            finally {
                ThreadProperties.clear();
                perf.stop();
            }
        }
        return reply;
    }

    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        this.throwUnsupportedOperation();
        return null;
    }

    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return null;
    }
}

