/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js;

import com.cognos.js.JSCategory;
import com.cognos.js.JobAsyncService;
import com.cognos.js.JobConfiguration;
import com.cognos.js.impl.JobRunManager;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;

public class JobServiceHandler
extends BasicHandler
implements Asyncable {
    private boolean m_suspended = false;

    public JobServiceHandler() {
        super(null);
    }

    public void start() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        this.setSuspended(false);
        JobRunManager.instance().start();
        DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.NC);
        SDSLogger.getLogger((SDSCategory)JSCategory.AUDIT).startService("JobService", "Success");
        perf.stop();
    }

    public void stop() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        JobRunManager.instance().stop();
        this.setSuspended(true);
        SDSLogger.getLogger((SDSCategory)JSCategory.AUDIT).stopService("JobService", "Success");
        perf.stop();
    }

    public void resume() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        JobRunManager.instance().start();
        this.setSuspended(false);
        SDSLogger.getLogger((SDSCategory)JSCategory.AUDIT).startService("JobService", "Success");
        perf.stop();
    }

    public void suspend(boolean immediately) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        if (immediately) {
            JobRunManager.instance().stop();
        } else {
            JobRunManager.instance().suspend();
        }
        this.setSuspended(true);
        SDSLogger.getLogger((SDSCategory)JSCategory.AUDIT).stopService("JobService", "Success");
        perf.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.isSuspended()) {
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
            return;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            ThreadProperties.setProperty((String)"componentID", (String)"JS");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)biBusEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            AxisServiceHandler handler = AxisServiceHandler.getHandler((IServiceConfiguration)JobConfiguration.getInstance(), (MessageContext)mc);
            handler.setAsAsync(true);
            handler.prepare();
            handler.execute();
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public AsyncService getAsyncRequest(MessageContext mc) {
        return new JobAsyncService(this, mc);
    }

    public void configure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        CRNProperties config = CRNProperties.getInstance();
        config.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        perf.stop();
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    private void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private boolean isSuspended() {
        return this.m_suspended;
    }
}

