/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRequestArguments;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.js.JSCategory;
import com.cognos.js.api.JobServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.TimeUtils;
import java.util.Date;
import java.util.Locale;

public class JobHistory {
    private SearchPathSingleObject m_historyPath;
    private JobBiBusHeaders m_headers;
    private boolean m_useTrusted;
    private String m_eventID = null;

    public JobHistory(AsynchOption historyLocation, JobBiBusHeaders headers, boolean useTrusted) throws JobServiceException {
        if (historyLocation == null || !AsynchOptionEnum.historyLocation.equals((Object)historyLocation.getName())) {
            throw new JobServiceException(I18NCode.JS_NO_HISTORY_PATH);
        }
        AsynchOptionSearchPathSingleObject aospso = (AsynchOptionSearchPathSingleObject)historyLocation;
        this.m_historyPath = aospso.getValue();
        this.m_headers = headers;
        this.m_useTrusted = useTrusted;
    }

    public JobHistory(String eventID, JobBiBusHeaders headers) throws JobServiceException {
        this.m_headers = headers;
        this.m_eventID = eventID;
    }

    public void addDetail(SeverityEnum severity, EventStatus status, LocalizableException e) throws JobServiceException {
        String detail = e.getLocalizedMessage(this.m_headers.getProductLocale());
        this.logDetail(severity, status, detail);
    }

    public void addDetail(SeverityEnum severity, EventStatus status, I18NCode messageCode) throws JobServiceException {
        String detail = I18NUtil.getMessage((I18NCode)messageCode, (Locale)this.m_headers.getProductLocale());
        this.logDetail(severity, status, detail);
    }

    public void addDetail(SeverityEnum severity, EventStatus status, I18NCode messageCode, Object[] params) throws JobServiceException {
        String detail = I18NUtil.getMessage((I18NCode)messageCode, (Object[])params, (Locale)this.m_headers.getProductLocale());
        this.logDetail(severity, status, detail);
    }

    public void logRuntime(Option[] options, ParameterValue[] params) throws JobServiceException {
        HistoryDetailRequestArguments hdra = new HistoryDetailRequestArguments();
        OptionArrayProp optionArray = new OptionArrayProp();
        optionArray.setValue(options);
        ParameterValueArrayProp paramArray = new ParameterValueArrayProp();
        paramArray.setValue(params);
        hdra.setOptions(optionArray);
        hdra.setParameters(paramArray);
        this.addBaseDetails(new BaseHistoryDetail[]{hdra});
    }

    private void logDetail(SeverityEnum severity, EventStatus status, String localizedDetail) throws JobServiceException {
        HistoryDetail historyDetail = new HistoryDetail();
        DateTimeProp detailTimeProp = new DateTimeProp();
        detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)new Date()));
        historyDetail.setDetailTime(detailTimeProp);
        if (localizedDetail != null) {
            StringProp stringProp = new StringProp();
            stringProp.setValue(localizedDetail);
            historyDetail.setDetail(stringProp);
        }
        if (severity != null) {
            SeverityEnumProp sevProp = new SeverityEnumProp();
            sevProp.setValue(severity);
            historyDetail.setSeverity(sevProp);
        }
        this.addBaseDetails(new BaseHistoryDetail[]{historyDetail});
    }

    private void addBaseDetails(BaseHistoryDetail[] details) throws JobServiceException {
        MonitorServiceClientPort port = null;
        try {
            if (this.m_eventID != null) {
                port = Client.instance().getMonitorServiceClient(this.m_headers);
                port.add(this.m_eventID, (BaseClass[])details, null, null);
            } else {
                port = Client.instance().getContentManagerServiceClient(this.m_headers);
                if (this.m_useTrusted) {
                    port.signNextRequest("JSM");
                    ((ContentManagerServiceClientPort)port).add(this.m_historyPath, (BaseClass[])details, new AddOptions());
                } else {
                    ((ContentManagerServiceClientPort)port).add(this.m_historyPath, (BaseClass[])details, new AddOptions());
                }
            }
        }
        catch (SDKClientException e) {
            String location = this.m_eventID != null ? this.m_eventID : this.m_historyPath.get_value();
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Error adding history detail; path [" + location + "], useTrusted [" + this.m_useTrusted + "], port [" + port.getPortName() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            throw new JobServiceException(I18NCode.MSG_ERROR_ADD_HISTORY_DETAIL, new String[]{port.getPortName(), location}, e);
        }
        catch (EMFSecurityException e) {
            String location = this.m_eventID != null ? this.m_eventID : this.m_historyPath.get_value();
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Security Error adding history detail; path [" + location + "], useTrusted [" + this.m_useTrusted + "], port [" + port.getPortName() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e.getLocalizedMessage());
            throw new JobServiceException(I18NCode.MSG_ERROR_ADD_HISTORY_DETAIL, new String[]{port.getPortName(), location});
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
    }
}

