/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.js.JSCategory;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.AsyncConversationStatusListener;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;

public class JobStep
implements IJob,
AsyncConversationStatusListener {
    public BaseClass m_stepObject;
    public ParameterValue[] m_params;
    public Option[] m_options;
    public JobBiBusHeaders m_headers;
    private AsynchReply m_reply;
    private AsyncConversation m_conversation = null;
    private EventStatus m_status = EventStatus.PENDING;

    public JobStep(BaseClass stepObject, ParameterValue[] params, Option[] options, JobBiBusHeaders headers) {
        this.m_stepObject = stepObject;
        this.m_params = params;
        this.m_options = options;
        BiBusHeader header = BiBusUtilities.getDeepCopy((BiBusHeader)headers.getBiBusHeader());
        if (header != null) {
            this.m_headers = new JobBiBusHeaders(header);
        } else {
            this.m_headers = headers;
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug("JobStep construction: error copying Header. Continuing to use existing header - this will affect audit logging for child steps");
        }
        this.m_conversation = new AsyncConversation();
        this.m_conversation.addStatusListener((AsyncConversationStatusListener)this);
    }

    @Override
    public AsynchReply run() throws JobServiceException {
        if (this.isCancelled()) {
            return null;
        }
        return this.getReply();
    }

    @Override
    public String getID() {
        return "";
    }

    @Override
    public EventStatus getStatus() {
        return this.m_status;
    }

    public void updateConversationStatus(AsynchReply reply, AsynchReplyStatusEnum status) {
        this.m_status = EventStatusUtil.getEventStatus((AsynchReplyStatusEnum)status);
    }

    public void onConversationCancel() {
    }

    @Override
    public synchronized void cancel(String user) {
        this.m_status = EventStatus.CANCELLED;
        this.m_conversation.cancel();
    }

    public synchronized void cancel() {
        this.cancel(null);
    }

    public synchronized boolean isCancelled() {
        return this.m_conversation.isCancelled();
    }

    protected void setReply(AsynchReply reply) {
        this.m_reply = reply;
    }

    protected AsynchReply getReply() {
        return this.m_reply;
    }

    @Override
    public void loadJob() throws JobServiceException {
    }
}

