/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.js.api.IHasTaskRunSpec;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.js.impl.JobBuilder;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusRunSpec;

public class StepDefinition
implements IJob,
IHasTaskRunSpec {
    BaseClass m_step;
    ParameterValue[] m_params;
    Option[] m_options;
    JobBiBusHeaders m_headers;
    String m_tenantID;
    private boolean m_cancelled = false;
    private IJob m_runningStep = null;
    private EventStatus m_status = EventStatus.PENDING;

    public StepDefinition(BaseClass step, ParameterValue[] params, Option[] options, JobBiBusHeaders headers, String tenantID) {
        this.m_step = step;
        this.m_params = params;
        this.m_options = options;
        this.m_headers = headers;
        this.m_tenantID = tenantID;
    }

    @Override
    public BiBusRunSpec createTaskRunSpec() {
        BiBusRunSpec runSpec = new BiBusRunSpec(this.m_headers.getBiBusHeader());
        runSpec.options = this.m_options;
        runSpec.parameters = this.m_params;
        runSpec.searchPath = this.m_step.getSearchPath().getValue();
        runSpec.taskStoreID = this.m_step.getStoreID().getValue().get_value();
        runSpec.serverGroup = null;
        runSpec.authenticated = true;
        runSpec.tenantID = this.m_tenantID;
        return runSpec;
    }

    @Override
    public synchronized void loadJob() throws JobServiceException {
        try {
            IJob step;
            String path = this.m_step.getSearchPath().getValue();
            SearchPathSingleObject spso = new SearchPathSingleObject();
            spso.set_value(path);
            this.m_runningStep = step = JobBuilder.getJobStep(spso, this.m_headers, this.m_params, this.m_options);
        }
        catch (JobServiceException e) {
            this.m_status = EventStatus.FAILED;
            this.m_cancelled = true;
            throw e;
        }
    }

    @Override
    public AsynchReply run() throws JobServiceException {
        AsynchReply reply = null;
        if (this.m_cancelled) {
            return reply;
        }
        try {
            if (this.m_runningStep == null) {
                this.loadJob();
            }
            reply = this.m_runningStep.run();
        }
        catch (JobServiceException e) {
            this.m_status = EventStatus.FAILED;
            throw e;
        }
        return reply;
    }

    @Override
    public EventStatus getStatus() {
        return this.m_status;
    }

    @Override
    public String getID() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancel(String user) {
        StepDefinition stepDefinition = this;
        synchronized (stepDefinition) {
            if (this.m_runningStep == null) {
                this.m_cancelled = true;
                this.m_status = EventStatus.CANCELLED;
            } else {
                this.m_runningStep.cancel(user);
                this.m_status = EventStatus.CANCELLED;
            }
        }
    }

    public BaseClass getBaseClass() {
        return this.m_step;
    }
}

