/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.athena.qls.bi.cache.CMDataSourceCache;
import com.ibm.cognos.athena.qls.bi.cache.ICMDataSourceFactory;
import com.ibm.cognos.athena.qls.bi.cache.QLSBIDataSourceCache;
import com.ibm.cognos.athena.qls.bi.cm.BaseCMCommand;
import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSource;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.cm.CMUtils;
import com.ibm.cognos.athena.qls.bi.cm.DSConnectionInfo;
import com.ibm.cognos.athena.qls.bi.cm.QLSBIDatasourceQueryResult;
import com.ibm.cognos.athena.qls.bi.cm.TM1ConnectionStringParser;
import com.ibm.cognos.athena.qls.bi.exception.AmbiguousConnectionException;
import com.ibm.cognos.athena.qls.bi.exception.AmbiguousSignonException;
import com.ibm.cognos.athena.qls.bi.exception.InvalidCredentialsException;
import com.ibm.cognos.athena.qls.bi.exception.LogonFailureException;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIMessageKeys;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableAxisFault;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableDatasourceException;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableException;
import com.ibm.cognos.athena.qls.bi.security.Credentials;
import com.ibm.cognos.athena.qls.bi.security.CryptoProvider;
import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.model.DataSource;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public class QLSBIService {
    private volatile boolean mInitialized;
    private CryptoProvider mCrypto;
    private IQueryLogicalStorage mQLS;
    private ISmartMetadata mSMD;
    private static final String STR_PASSPORT = "passport";
    private static final String STR_CAFID = "cafId";
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_bi");

    public synchronized boolean isInitialzed() {
        return this.mInitialized;
    }

    public synchronized void initialize(Properties configuration, IQueryLogicalStorage qls, ISmartMetadata smd) throws Exception {
        if (this.mInitialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.mQLS = qls;
        this.mSMD = smd;
        this.mCrypto = new CryptoProvider();
        this.mCrypto.initialize();
        this.mInitialized = true;
        logger.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.QLSBISERVICE, (Status)Status.SUCCESS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() throws Exception {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        Exception error = null;
        try {
            this.mCrypto.terminate();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::terminate()");
            error = ex;
        }
        finally {
            this.mCrypto = null;
        }
        this.mQLS = null;
        this.mSMD = null;
        this.mInitialized = false;
        if (null != error) {
            logger.auditSystemEvent(LogEventHelper.createStopServiceEvent((ObjectType)ObjectType.QLSBISERVICE, (Status)Status.FAILURE));
            throw error;
        }
        logger.auditSystemEvent(LogEventHelper.createStopServiceEvent((ObjectType)ObjectType.QLSBISERVICE, (Status)Status.SUCCESS));
    }

    public CryptoProvider getCrypto() {
        return this.mCrypto;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public ISmartMetadata getSMD() {
        return this.mSMD;
    }

    private CMDataSource getCMDatasourceFromCache(final String cmDatasourceName, final BiBusHeader header, ISession session) throws RecoverableAxisFault {
        ICMDataSourceFactory cmDataSourceFactory = new ICMDataSourceFactory(){

            public CMDataSource create() throws RecoverableAxisFault {
                return CMDataSource.create(cmDatasourceName, header);
            }
        };
        CMDataSourceCache cmDatasourceCache = CMDataSourceCache.getDataSourceCache(session);
        return cmDatasourceCache.getOrCreateDataSource(cmDatasourceName, cmDataSourceFactory);
    }

    private IDataSource createIDataSource(String cmDatasourceName, CMConnection connection, Credentials credentials, BiBusHeader bibusHeader) {
        CAF caf;
        String strPassport = null;
        String strCAFID = null;
        CAMPassport passport = bibusHeader.getCAM().getCAMPassport();
        if (passport != null) {
            strPassport = passport.getId();
        }
        if ((caf = bibusHeader.getCAF()) != null) {
            strCAFID = caf.getContextID();
        }
        TM1ConnectionStringParser parser = new TM1ConnectionStringParser();
        IConnectionSpec connSpec = parser.parseConnectionString(connection.getConnectionString(), credentials);
        connSpec.setParameterValue(STR_PASSPORT, (Object)strPassport);
        connSpec.setParameterValue(STR_CAFID, (Object)strCAFID);
        DataSource qlsDatasource = new DataSource(EDataSourceType.DIMENSIONAL, cmDatasourceName);
        qlsDatasource.setConnectionSpec(connSpec);
        if (logger.isDebugEnabled()) {
            logger.debug("qlsDatasource: " + qlsDatasource.toString(), this.getClass().getName() + "::createEnterpriseDataSource()");
        }
        return qlsDatasource;
    }

    private void testDatasourceCredentials(Locale locale, CMDataSource cmDatasource, CMConnection cmConnection, CMSignon cmSignon, IDataSource dataSource) throws LogonFailureException {
        IDimensionalDataProvider provider = (IDimensionalDataProvider)this.mQLS.getProviderManager().getDataProvider("tm1");
        try {
            provider.testDataSource(dataSource);
        }
        catch (com.ibm.cognos.aurora.qls.query.provider.connection.InvalidCredentialsException e) {
            throw new InvalidCredentialsException(locale, cmDatasource, cmConnection, cmSignon, "TM1");
        }
    }

    private IDataSource validateCMDataSource(Locale locale, BiBusHeader header, CMDataSource cmDataSource, String strDataSourceConnectionInfo) throws RecoverableDatasourceException {
        Credentials credentials;
        CMSignon signon;
        CMConnection connection;
        DSConnectionInfo dsConnectionInfo = new DSConnectionInfo(strDataSourceConnectionInfo, this.getCrypto());
        Collection<CMConnection> connections = cmDataSource.getConnections();
        if (connections.size() <= 0) {
            throw new QLSBIRuntimeException(QLSBIMessageKeys.DS_ConnectionNotFound, cmDataSource.getName());
        }
        if (dsConnectionInfo.getConnectionPath() == null && connections.size() > 1) {
            throw new AmbiguousConnectionException(locale, "TM1", cmDataSource);
        }
        String connectionName = CMUtils.getConnectionFromSearchPath(dsConnectionInfo.getConnectionPath());
        if (connectionName == null) {
            if (connections.size() > 1) {
                throw new AmbiguousConnectionException(locale, "TM1", cmDataSource);
            }
            connection = connections.iterator().next();
            if (connection == null) {
                throw new QLSBIRuntimeException(QLSBIMessageKeys.DS_ConnectionNotFound, cmDataSource.getName());
            }
        } else {
            connection = cmDataSource.getConnection(connectionName);
            if (connection == null) {
                throw new QLSBIRuntimeException(QLSBIMessageKeys.DS_ConnectionNotFoundParam, connectionName, (Object)cmDataSource.getName());
            }
        }
        if (dsConnectionInfo.getCredentials() == null) {
            Collection<CMSignon> signons = connection.getSignons();
            if (signons.size() <= 0) {
                throw new InvalidCredentialsException(locale, cmDataSource, connection, "TM1");
            }
            if (dsConnectionInfo.getSignonPath() == null && signons.size() > 1) {
                throw new AmbiguousSignonException(locale, cmDataSource, connection, "TM1");
            }
            String signonName = CMUtils.getSignonFromSearchPath(dsConnectionInfo.getSignonPath());
            if (signonName == null) {
                if (signons.size() > 1) {
                    throw new AmbiguousSignonException(locale, cmDataSource, connection, "TM1");
                }
                signon = signons.iterator().next();
            } else {
                signon = connection.getSignon(signonName);
                if (signon == null) {
                    throw new QLSBIRuntimeException(QLSBIMessageKeys.DS_SignonNotFoundParam, signonName, (Object)connection.getDefaultName());
                }
            }
            XmlEncodedXML credentialsXML = new XmlEncodedXML();
            credentialsXML.set_value(signon.getCredential());
            credentials = this.getCrypto().retrieveSignonsCredentials(credentialsXML.get_value());
        } else {
            signon = null;
            credentials = dsConnectionInfo.getCredentials();
        }
        if (dsConnectionInfo.isPersist()) {
            BaseCMCommand.createPersonalDatasourceSignon(cmDataSource.getName(), connection.getDefaultName(), credentials.getUsername(), credentials.getPassword(), header);
        }
        IDataSource dataSource = this.createIDataSource(cmDataSource.getName(), connection, credentials, header);
        this.testDatasourceCredentials(locale, cmDataSource, connection, signon, dataSource);
        return dataSource;
    }

    public QLSBIDatasourceQueryResult getIDataSource(String cmDatasourceName, final BiBusHeader header, final ISession session, final String strDataSourceConnectionInfo) throws RecoverableException {
        long nanoNow = System.nanoTime();
        final CMDataSource cmDatasource = this.getCMDatasourceFromCache(cmDatasourceName, header, session);
        QLSBIDataSourceCache.IDataSourceFactory dataSourceFactory = new QLSBIDataSourceCache.IDataSourceFactory(){

            public IDataSource create() throws InterruptedException, ExecutionException, RecoverableDatasourceException {
                return QLSBIService.this.validateCMDataSource(session.getProductLocale(), header, cmDatasource, strDataSourceConnectionInfo);
            }
        };
        QLSBIDataSourceCache datasourceCache = QLSBIDataSourceCache.getDataSourceCache(session);
        IDataSource datasource = datasourceCache.getOrCreateDataSource(cmDatasourceName, dataSourceFactory);
        BIBusEnvelope biBusEnvelope = cmDatasource.getNanoTimeStamp() > nanoNow ? cmDatasource.getBIBusEnvelope() : null;
        return new QLSBIDatasourceQueryResult(biBusEnvelope, datasource);
    }
}

