/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceCredential;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.QueryCacheResult;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.ibm.cognos.athena.qls.bi.cm.BaseCMCommand;
import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSource;
import com.ibm.cognos.athena.qls.bi.cm.CMObject;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.cm.CMUtils;
import com.ibm.cognos.athena.qls.bi.exception.AxisFaultException;
import com.ibm.cognos.athena.qls.bi.exception.AxisFaultExceptionFactory;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableAxisFault;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.util.collection.MapCast;
import com.ibm.cognos.aurora.core.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.commons.collections.map.Flat3Map;

public final class CMDataSourceViaCMCService
extends CMDataSource {
    private static final ClassEnum DATASOURCE_CLASSENUM = ClassEnum.fromString((String)"dataSource");
    private static final ClassEnum DATASOURCECONNECTION_CLASSENUM = ClassEnum.fromString((String)"dataSourceConnection");
    private static final ClassEnum DATASOURCESIGNON_CLASSENUM = ClassEnum.fromString((String)"dataSourceSignon");
    private static final ClassEnum DATASOURCECREDENTIAL_CLASSENUM = ClassEnum.fromString((String)"dataSourceCredential");

    public static CMDataSource createDS(String name, BiBusHeader header) throws RecoverableAxisFault {
        return new CMDataSourceViaCMCService(name, header);
    }

    private CMDataSourceViaCMCService(String name, BiBusHeader header) throws RecoverableAxisFault {
        super(name);
        PerfLogEvent e = null;
        if (logger.isPerfDebugEnabled()) {
            e = logger.startPerfDebug(this.getClass().getName(), "", "Start calling queryForCMInfo", LogAction.CALL);
        }
        this.queryForCMInfo(header, name);
        this.setNanoTimeStamp(System.nanoTime());
        if (e != null) {
            logger.stopPerfDebug(e, "Returned queryForCMInfo", LogAction.RETURN);
        }
    }

    private void queryForCMInfo(BiBusHeader bibusHeader, String searchPath) throws RecoverableAxisFault {
        ContentManagerCacheService_PortType port = null;
        try {
            port = BaseCMCommand.getContentManagerCacheServicePort(bibusHeader);
            SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
            searchPathSingleObject.set_value(this.buildSearchPath());
            ClassEnum searchType = DATASOURCESIGNON_CLASSENUM;
            ClassEnum[] entries = new ClassEnum[]{DATASOURCESIGNON_CLASSENUM};
            ArrayList<Option> optionList = new ArrayList<Option>();
            CMUtils.setOptionsForQueryCache(optionList, null);
            Option[] options = new Option[]{};
            if (optionList.size() > 0) {
                options = optionList.toArray(new Option[optionList.size()]);
            }
            String pspt = "";
            boolean isAuditDebugEventEnabled = logger.isAuditDebugEventEnabled();
            if (isAuditDebugEventEnabled) {
                HashMap<String, String> logdata = new HashMap<String, String>();
                logdata.put("searchPath", searchPathSingleObject.get_value());
                logdata.put("searchType", DATASOURCESIGNON_CLASSENUM.getValue());
                logdata.put("options", ((Object)optionList).toString());
                if (bibusHeader.getCAM() != null && bibusHeader.getCAM().getCAMPassport() != null) {
                    pspt = bibusHeader.getCAM().getCAMPassport().getId();
                }
                logger.auditDebugEvent(new AuditLogBaseEvent(pspt, "", "", Operation.QUERYCM, LogDataHelper.createFunctionDebugLogData((String)"queryCache", logdata)));
            }
            PerfLogEvent qcEvent = null;
            if (logger.isPerfDebugEnabled()) {
                qcEvent = logger.startPerfDebug(this.getClass().getName(), "queryForCMInfo", "Start querying CM Cache", LogAction.CALL);
            }
            QueryCacheResult qcResult = port.queryCache(searchPathSingleObject, searchType, entries, options);
            if (qcEvent != null) {
                logger.stopPerfDebug(qcEvent, "Finished querying CM Cache", LogAction.RETURN);
            }
            this.setBIBusEnvelope(BaseCMCommand.getBIBusEnvelope((Stub)port));
            BaseClass[] resultObjects = qcResult.getObjects();
            LinkedList<CMSignon> dataSourceSignons = new LinkedList<CMSignon>();
            LinkedList<CMSignon> dataSourceCredentials = new LinkedList<CMSignon>();
            this.connections = MapCast.uncheckedCast((Map)new Flat3Map());
            for (BaseClass object : resultObjects) {
                CMSignon cmSignon;
                if (object.getObjectClass().getValue() == DATASOURCECONNECTION_CLASSENUM) {
                    CMConnection cmConnection = new CMConnection((DataSourceConnection)object);
                    if (!cmConnection.getBooleanProperty("disabled", false)) {
                        this.connections.put(cmConnection.getDefaultName(), cmConnection);
                    }
                    if (this.dataSource != null) continue;
                    this.createDataSource((DataSourceConnection)object);
                    continue;
                }
                if (object.getObjectClass().getValue() == DATASOURCESIGNON_CLASSENUM) {
                    cmSignon = new CMSignon((DataSourceSignon)object);
                    if (cmSignon.getBooleanProperty("disabled", false)) continue;
                    dataSourceSignons.add(cmSignon);
                    continue;
                }
                if (object.getObjectClass().getValue() != DATASOURCECREDENTIAL_CLASSENUM || (cmSignon = new CMSignon((DataSourceCredential)object)).getBooleanProperty("disabled", false)) continue;
                dataSourceCredentials.add(cmSignon);
            }
            this.addSignonsAsChildrenOfConnection(dataSourceSignons, dataSourceCredentials);
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent(pspt, "", "", Operation.QUERYCM, LogDataHelper.createFunctionDebugLogData((String)"queryForCMInfo", (String)"connections", (String)this.connections.toString())));
            }
        }
        catch (AxisFault e) {
            RecoverableAxisFault recoverableAxisFault = AxisFaultExceptionFactory.create(e);
            if (recoverableAxisFault == null) {
                throw new AxisFaultException(e);
            }
            throw recoverableAxisFault;
        }
        catch (Exception e) {
            throw QLSBIRuntimeException.wrap(e);
        }
    }

    private String buildSearchPath() {
        String packagePath = "/content/package[@defaultName='dummyName']/";
        StringBuilder searchPath = new StringBuilder();
        searchPath.append(packagePath);
        searchPath.append("personalDataSourceSignon(");
        searchPath.append(XMLUtils.xPathLiteral((String)this.dsName));
        searchPath.append(")");
        String searchPathStr = searchPath.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("SearchPath: " + searchPathStr, this.getClass().getName() + "::buildSearchPath");
        }
        return searchPathStr;
    }

    private void createDataSource(DataSourceConnection dsConnection) {
        if (dsConnection.getAncestors().getValue() != null) {
            AncestorInfo[] ancestors;
            for (AncestorInfo member : ancestors = dsConnection.getAncestors().getValue()) {
                if (member.getObjectClass() != DATASOURCE_CLASSENUM) continue;
                this.dataSource = new CMObject(member);
                if (!logger.isDebugEnabled()) break;
                logger.debug("Created dataSource: " + this.dataSource.toString(), this.getClass().getName() + "::createDataSource");
                break;
            }
        }
    }
}

