/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.ibm.cognos.athena.qls.bi.cm.BaseCMCommand;
import com.ibm.cognos.athena.qls.bi.cm.SupportedLocales;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import org.apache.axis.AxisFault;

public class CMUtils {
    static final String CM_CACHESERVICE_DISABLED = "contentManagerCacheService is disabled";
    static final String CMCACHE_CONTEXT_NAME = "http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context";
    public static final String CM_USERPREFVAR_CONTENTLOCALE = "contentLocale";
    public static final String CM_USERPREFVAR_PRODUCTLOCALE = "productLocale";
    public static final String DATASOURCECONNECTIONINFO = "datasourceconnectioninfo";
    public static final char REGION_SEPARATOR1 = '-';
    public static final char REGION_SEPARATOR2 = '_';

    public static BiBusHeader buildBiBusHeader(BIBusEnvelope clientEnvelope) {
        BiBusHeader header = BaseCMCommand.buildBiBusHeaderFrom(clientEnvelope);
        return header;
    }

    public static BiBusHeader buildBiBusHeader(String clientEnvelope) throws UnsupportedEncodingException, SOAPException {
        ByteArrayInputStream is = new ByteArrayInputStream(clientEnvelope.getBytes("UTF8"));
        BIBusEnvelope envelope = new BIBusEnvelope((InputStream)is);
        return BaseCMCommand.buildBiBusHeaderFrom(envelope);
    }

    public static boolean parseFaultForDisabledCMCache(AxisFault aFault) {
        return CMUtils.parseFaultForDisabledCMCache(aFault.dumpToString());
    }

    public static boolean parseFaultForDisabledCMCache(String axisFaultDumpedToString) {
        return axisFaultDumpedToString.indexOf(CM_CACHESERVICE_DISABLED) != -1;
    }

    public static void setOptionsForQueryCache(List<Option> optionList, String cmCacheContext) {
        if (cmCacheContext == null) {
            return;
        }
        XmlEncodedXML xmlEncodedXML = new XmlEncodedXML();
        xmlEncodedXML.set_value(cmCacheContext);
        GenericOptionXMLEncodedXML genericOptionXMLEncodedXML = new GenericOptionXMLEncodedXML();
        genericOptionXMLEncodedXML.setName(CMCACHE_CONTEXT_NAME);
        genericOptionXMLEncodedXML.setValue(xmlEncodedXML);
        optionList.add((Option)genericOptionXMLEncodedXML);
    }

    public static SupportedLocales getSupportedLocales(BiBusHeader header) {
        UserPreferenceVar[] userPrefs;
        Locale productLocale = null;
        Locale contentLocale = null;
        for (UserPreferenceVar pref : userPrefs = header.getUserPreferenceVars()) {
            if (pref.getName().equals(CM_USERPREFVAR_CONTENTLOCALE)) {
                contentLocale = CMUtils.createLocaleFromPreference(pref.getValue());
            }
            if (pref.getName().equals(CM_USERPREFVAR_PRODUCTLOCALE)) {
                productLocale = CMUtils.createLocaleFromPreference(pref.getValue());
            }
            if (productLocale != null && contentLocale != null) break;
        }
        return new SupportedLocales(productLocale, contentLocale);
    }

    public static Locale createLocaleFromPreference(String localePref) {
        if (localePref == null || "".equals(localePref)) {
            return Locale.getDefault();
        }
        int dashPos = localePref.indexOf(45);
        int underscorePos = localePref.indexOf(95);
        if (dashPos != -1) {
            return new Locale(localePref.substring(0, dashPos), localePref.substring(dashPos + 1));
        }
        if (underscorePos != -1) {
            return new Locale(localePref.substring(0, underscorePos), localePref.substring(underscorePos + 1));
        }
        return new Locale(localePref);
    }

    public static String getConnectionFromSearchPath(String searchPath) {
        return CMUtils.getElementFromSearchPath(searchPath, "dataSourceConnection[@name='");
    }

    public static String getSignonFromSearchPath(String searchPath) {
        return CMUtils.getElementFromSearchPath(searchPath, "dataSourceSignon[@name='");
    }

    private static String getElementFromSearchPath(String searchPath, String element) {
        if (searchPath == null) {
            return null;
        }
        int index = searchPath.indexOf(element);
        if (index == -1) {
            return null;
        }
        if ((index = (searchPath = searchPath.substring(index + element.length())).indexOf("'")) == -1) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_UnexpectedException);
        }
        return searchPath.substring(0, index);
    }
}

