/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.security.Credentials;
import com.ibm.cognos.athena.qls.bi.security.CryptoProvider;
import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.pool.XQESAXReaderPool;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DSConnectionInfo {
    private String connectionPath = null;
    private String signonPath = null;
    private Credentials credentials = null;
    private boolean persist;

    public DSConnectionInfo(String _strDataSourceConnectionInfo, CryptoProvider crypto) {
        SAXReader xmlReader;
        if (_strDataSourceConnectionInfo == null) {
            return;
        }
        try {
            xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        }
        catch (Exception e1) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        Element root = null;
        String encryptedUserName = null;
        String encryptedPassword = null;
        boolean decrypt = false;
        try {
            Element passwordElement;
            Element usernameElement;
            Element signonPathElement;
            Document doc = xmlReader.read((Reader)new StringReader(_strDataSourceConnectionInfo));
            root = doc.getRootElement();
            String persistString = root.attributeValue("persist");
            this.persist = persistString == null || persistString.isEmpty() ? false : Boolean.parseBoolean(persistString);
            Element connectionPathElement = root.element("dataSourceConnection");
            if (connectionPathElement != null) {
                this.connectionPath = connectionPathElement.getText();
            }
            if ((signonPathElement = root.element("dataSourceSignon")) != null) {
                this.signonPath = signonPathElement.getText();
            }
            if ((usernameElement = root.element("username")) != null) {
                encryptedUserName = usernameElement.getText();
            }
            if ((passwordElement = root.element("password")) != null) {
                encryptedPassword = passwordElement.getText();
            }
            String userName = null;
            String password = null;
            if (encryptedUserName != null && !encryptedUserName.isEmpty()) {
                userName = decrypt ? crypto.decrypt(encryptedUserName, 0, "UTF-8") : encryptedUserName;
            }
            if (encryptedPassword != null && !encryptedPassword.isEmpty()) {
                password = decrypt ? crypto.decrypt(encryptedPassword, 0, "UTF-8") : encryptedPassword;
            }
            if (userName != null && !userName.isEmpty()) {
                this.credentials = new Credentials(userName, password, null);
            }
        }
        catch (DocumentException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        finally {
            try {
                XQESAXReaderPool.getInstance().returnReader(xmlReader);
            }
            catch (Exception e) {
                throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
            }
        }
    }

    private boolean isEncoded(String userId) {
        byte[] arrPassportBytes;
        try {
            arrPassportBytes = userId.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        return Base64.isArrayByteBase64((byte[])arrPassportBytes);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getConnectionPath() {
        return this.connectionPath;
    }

    public String getSignonPath() {
        return this.signonPath;
    }

    public boolean isPersist() {
        return this.persist;
    }
}

