/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.ibm.cognos.athena.qls.bi.cm.IConnectionStringParser;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIMessageKeys;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.security.Credentials;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.core.model.ConnectionSpec;

public class TM1ConnectionStringParser
implements IConnectionStringParser {
    private static final String TM1ADMINHOST = "TM1AdminHost=";
    private static final String TM1SERVERNAME = "TM1ServerName=";
    private static final String DELIMITER = ";";
    public static final String PROVIDERTYPE_TM1 = "tm1";
    public static final String ADMINHOST = "adminHost";
    public static final String SERVERNAME = "serverName";

    @Override
    public IConnectionSpec parseConnectionString(String connString, Credentials credentials) {
        int index = connString.indexOf(TM1ADMINHOST);
        if (index == -1) {
            throw new QLSBIRuntimeException(QLSBIMessageKeys.CON_MalformedConnection, connString, (Object)TM1ADMINHOST);
        }
        String adminHostSubstring = connString.substring(index);
        if ((index = adminHostSubstring.indexOf(DELIMITER)) == -1) {
            throw new QLSBIRuntimeException(QLSBIMessageKeys.CON_InvalidConnection, connString);
        }
        String adminHost = adminHostSubstring.substring(TM1ADMINHOST.length(), index);
        index = connString.indexOf(TM1SERVERNAME);
        if (index == -1) {
            throw new QLSBIRuntimeException(QLSBIMessageKeys.CON_MalformedConnection, connString, (Object)TM1SERVERNAME);
        }
        String serverNameSubstring = connString.substring(index);
        if ((index = serverNameSubstring.indexOf(DELIMITER)) == -1) {
            index = serverNameSubstring.length();
        }
        String serverName = serverNameSubstring.substring(TM1SERVERNAME.length(), index);
        ConnectionSpec connSpec = new ConnectionSpec();
        connSpec.setParameterValue("providerType", (Object)PROVIDERTYPE_TM1);
        connSpec.setParameterValue(ADMINHOST, (Object)adminHost);
        connSpec.setParameterValue(SERVERNAME, (Object)serverName);
        connSpec.setParameterValue("user", (Object)credentials.getUsername());
        if (credentials.getPassword() != null) {
            connSpec.setParameterValue("password", (Object)credentials.getPassword());
        }
        return connSpec;
    }
}

