/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.exception;

import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSource;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIMessageKeys;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableDatasourceException;
import java.util.Collection;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AmbiguousConnectionException
extends RecoverableDatasourceException {
    private final Collection<CMConnection> m_arrDataSourceConnections;
    public static final String TM1_DATASOURCE_TYPE = "TM1";
    static final long serialVersionUID = 23478237445865L;

    public AmbiguousConnectionException(Locale locale, String _strDataSourceType, CMDataSource _DataSource) {
        super(locale, QLSBIMessageKeys.DS_AmbiguousConnection, _DataSource.getName(), _DataSource, _strDataSourceType);
        this.m_arrDataSourceConnections = _DataSource.getConnections();
    }

    @Override
    public String getFaultCode() {
        return "CQE-801";
    }

    @Override
    protected Element getDataSourceElement() {
        Element dataSourceElement = this.getBaseDataSourceElement();
        for (CMConnection connection : this.m_arrDataSourceConnections) {
            if (connection == null) continue;
            Element connectionElement = this.getBaseConnectionElement(connection);
            for (CMSignon signon : connection.getSignons()) {
                connectionElement.add(this.getBaseSignonElement(signon));
            }
            dataSourceElement.add(connectionElement);
        }
        return dataSourceElement;
    }

    @Override
    protected Element getBaseSignonElement(CMSignon signon) {
        Element signonElement = DocumentHelper.createElement((String)"signon");
        Element nameElement = signonElement.addElement("name");
        nameElement.addAttribute("value", "");
        Element searchPathElement = signonElement.addElement("searchPath");
        searchPathElement.addAttribute("value", "");
        return signonElement;
    }
}

