/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.exception;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSource;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIMessageKeys;
import com.ibm.cognos.athena.qls.bi.exception.SingleConnectionRecoverableException;
import java.util.Locale;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public abstract class LogonFailureException
extends SingleConnectionRecoverableException {
    private final CMSignon signon;
    static final long serialVersionUID = 754378423723487L;
    private subCodeEnum subCode = subCodeEnum.UNKNOWN;
    private String faultSubString = null;
    private String additionalInfo = null;

    public LogonFailureException(Locale locale, CMDataSource _DataSource, CMConnection _DataSourceConnection, CMSignon _signon, String _strDataSourceType, subCodeEnum _Subcode, String _faultSubString) {
        super(locale, QLSBIMessageKeys.DS_LogonFailure, _DataSource, _DataSourceConnection, _strDataSourceType);
        this.signon = _signon;
        this.subCode = _Subcode;
        this.faultSubString = _faultSubString;
    }

    public subCodeEnum getSubCode() {
        return this.subCode;
    }

    public String getFaultSubString() {
        return this.faultSubString;
    }

    @Override
    public String getFaultCode() {
        return "CQE-803";
    }

    private void addSubfaultElements(Element faultElement) {
        Element fault;
        DOMElement faultSubcode = new DOMElement(new QName("faultSubcode"));
        switch (this.subCode) {
            case INVALID_CREDENTIALS: {
                faultSubcode.addText("1");
                break;
            }
            case INVALID_CONN_STRING: {
                faultSubcode.addText("2");
                break;
            }
            case INVALID_SERVER: {
                faultSubcode.addText("3");
                break;
            }
            case NO_CONNECTION: {
                faultSubcode.addText("4");
                break;
            }
            case MAX_CONNECTIONS: {
                faultSubcode.addText("5");
                break;
            }
            case INVALID_CUBE_PWD: {
                faultSubcode.addText("6");
                break;
            }
            case XML_TAG_FAULT: {
                faultSubcode.addText("7");
                break;
            }
            default: {
                faultSubcode.addText("99");
            }
        }
        faultElement.add((Element)faultSubcode);
        DOMElement faultSubstring = new DOMElement(new QName("faultSubstring"));
        faultSubstring.addText(this.faultSubString);
        faultElement.add((Element)faultSubstring);
        if (this.additionalInfo == null) {
            return;
        }
        try {
            fault = DocumentHelper.parseText((String)this.faultSubString).getRootElement();
        }
        catch (DocumentException e) {
            return;
        }
        Element faultInfo = DocumentHelper.createElement((String)"additionalFaultInfo");
        faultInfo.add(fault);
        faultElement.add(faultInfo);
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        this.addSubfaultElements(faultElement);
        faultElement.add(this.getFaultDataSourceElement());
        Element faultConnectionElement = this.getFaultConnection();
        faultElement.add(faultConnectionElement);
        if (this.signon != null) {
            Element faultSignon = this.getFaultSignon();
            faultElement.add(faultSignon);
        }
        Element datasouceElement = this.getDataSourceElement();
        faultElement.add(datasouceElement);
        return faultEnvelope;
    }

    protected Element getFaultDataSourceElement() {
        Element dataSourceElement = DocumentHelper.createElement((String)"faultDataSource");
        dataSourceElement.addAttribute("value", this.dataSource.getName());
        return dataSourceElement;
    }

    @Override
    protected Element getFaultConnection() {
        Element connectionElement = DocumentHelper.createElement((String)"faultConnection");
        Element searchPathElement = connectionElement.addElement("searchPath");
        searchPathElement.addAttribute("value", this.m_dataSourceConnection.getSearchPath());
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", this.m_dataSourceConnection.getDefaultName());
        Element connectionStringElement = connectionElement.addElement("connectionString");
        connectionStringElement.addAttribute("value", this.m_dataSourceConnection.getConnectionString());
        return connectionElement;
    }

    protected Element getFaultSignon() {
        Element connectionElement = DocumentHelper.createElement((String)"faultSignon");
        Element searchPathElement = connectionElement.addElement("searchPath");
        searchPathElement.addAttribute("value", this.signon.getSearchPath());
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", this.signon.getDefaultName());
        return connectionElement;
    }

    @Override
    protected Element getDataSourceElement() {
        Element dataSourceElement = this.getBaseDataSourceElement();
        Element connectionElement = this.getBaseConnectionElement(this.m_dataSourceConnection);
        if (this.signon != null) {
            connectionElement.add(this.getBaseSignonElement(this.signon));
        }
        dataSourceElement.add(connectionElement);
        return dataSourceElement;
    }

    public static enum subCodeEnum {
        INVALID_CREDENTIALS,
        MISSING_CREDENTIALS,
        INVALID_CONN_STRING,
        INVALID_SERVER,
        NO_CONNECTION,
        MAX_CONNECTIONS,
        INVALID_CUBE_PWD,
        XML_TAG_FAULT,
        UNKNOWN;

    }
}

