/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.siebel.sdb;

import com.cognos.cdms.ds.logger.Logger;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SDBDefaultLogger
implements Logger {
    private static final String LEVEL_DEBUG = "DEBUG";
    private static final String LEVEL_INFO = "INFO";
    private static final String LEVEL_ERROR = "ERROR";
    private Class<?> mClass = null;

    public SDBDefaultLogger(Class<?> clazz) {
        this.mClass = clazz;
    }

    @Override
    public boolean isDebug() {
        return true;
    }

    private void printToConsole(String level, String str) {
        String className = null;
        className = this.mClass != null ? this.mClass.getName() : "";
        System.out.println(new Date(System.currentTimeMillis()).toString() + ":" + level + ":" + className + " - " + str);
    }

    @Override
    public void debug(String logMsg) {
        this.printToConsole(LEVEL_DEBUG, logMsg);
    }

    @Override
    public void debug(String errorMsg, Throwable t) {
        this.printToConsole(LEVEL_DEBUG, errorMsg);
        t.printStackTrace();
    }

    @Override
    public boolean isInfo() {
        return true;
    }

    @Override
    public void info(String logMsg) {
        this.printToConsole(LEVEL_INFO, logMsg);
    }

    @Override
    public void info(String errorMsg, Throwable t) {
        this.printToConsole(LEVEL_INFO, errorMsg);
        t.printStackTrace();
    }

    @Override
    public void log(String logMsg) {
        this.printToConsole(LEVEL_ERROR, logMsg);
    }

    @Override
    public void log(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public void log(String errorMsg, Throwable t) {
        this.printToConsole(LEVEL_ERROR, errorMsg);
    }
}

