/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service;

import java.util.Set;

class Manifest {
    private final Set<String> files;
    private final String adapterId;
    private final String name;
    private static final String MANIFEST_OPEN = "<manifest>";
    private static final String MANIFEST_CLOSE = "</manifest>";
    private static final String ADAPTER_OPEN = "<adapter>";
    private static final String ADAPTER_CLOSE = "</adapter>";
    private static final String BUNDLE_OPEN = "<bundle>";
    private static final String BUNDLE_CLOSE = "</bundle>";
    private static final String ATTACH_OPEN = "<attach>";
    private static final String ATTACH_CLOSE = "</attach>";
    private static final String ID_OPEN = "<id>";
    private static final String ID_CLOSE = "</id>";
    private static final String FILE_OPEN = "<file>";
    private static final String FILE_CLOSE = "</file>";
    private static final String RELATIVEPATH_OPEN = "<relativePath>";
    private static final String RELATIVEPATH_CLOSE = "</relativePath>";
    private static final String LOCATION_OPEN = "<location>";
    private static final String LOCATION_CLOSE = "</location>";

    Manifest(Set<String> files, String adapterId, String name) {
        this.files = files;
        this.adapterId = adapterId;
        this.name = name;
    }

    String asXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(MANIFEST_OPEN).append(ADAPTER_OPEN).append(ID_OPEN);
        xml.append(this.adapterId);
        xml.append(ID_CLOSE).append(ADAPTER_CLOSE);
        xml.append(BUNDLE_OPEN).append(ATTACH_OPEN);
        for (String file : this.files) {
            xml.append(FILE_OPEN).append(file).append(FILE_CLOSE);
        }
        xml.append(ATTACH_CLOSE);
        if ("com.ibm.cognos.adapters.rave2.RAVEChartAdapter".equals(this.adapterId)) {
            xml.append(RELATIVEPATH_OPEN).append("true").append(RELATIVEPATH_CLOSE);
        }
        String bundleID = this.name;
        if (this.name.contains(",")) {
            bundleID = this.name.split(",")[0];
            xml.append(LOCATION_OPEN).append(bundleID + '/' + bundleID + ".min.js").append(LOCATION_CLOSE);
        } else {
            xml.append(LOCATION_OPEN).append(bundleID + '/' + "implementation.json").append(LOCATION_CLOSE);
        }
        xml.append(BUNDLE_CLOSE).append(MANIFEST_CLOSE);
        return xml.toString();
    }
}

