/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.adapter;

import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.VisualizationException;
import com.ibm.ba.vis.service.adapter.AdapterManager;
import com.ibm.ba.vis.service.adapter.InteractiveOutputAdapter;
import com.ibm.ba.vis.service.definition.Definition;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;

public class DefaultAdapterManager
implements AdapterManager {
    @Override
    public Adapter getAdapter(Definition definition, String format) {
        String adapterId;
        String string = adapterId = definition == null ? "" : definition.getAdapterId();
        if ("interactive".equalsIgnoreCase(format) && !"com.ibm.cognos.adapters.rave.RAVEChartAdapter".equalsIgnoreCase(adapterId) && !"com.ibm.cognos.adapters.rave2.RAVEChartAdapter".equalsIgnoreCase(adapterId) && !"com.ibm.cognos.adapters.vida.VIDAChartAdapter".equalsIgnoreCase(adapterId)) {
            return new InteractiveOutputAdapter(definition);
        }
        return this.createAdapter(adapterId);
    }

    private Adapter createAdapter(String adapterId) {
        try {
            Class<?> adapterClass = this.getClass().getClassLoader().loadClass(adapterId);
            Constructor<?> constructor = adapterClass.getConstructor(new Class[0]);
            return (Adapter)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String template = Messages.getString("unableLoadAdapter");
            String message = MessageFormat.format(template, adapterId);
            throw new VisualizationException(message, e);
        }
    }
}

