/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.adapter;

import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.definition.Definition;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class InteractiveOutputAdapter
implements Adapter {
    private final Definition definition;

    InteractiveOutputAdapter(Definition definition) {
        this.definition = definition;
    }

    public void setData(Map<String, DataSet> data, Map<String, Boolean> override) {
    }

    public void setProperties(Map<String, Object> properties) {
    }

    public void setFormatter(Formatter formatter) {
    }

    public Map<String, byte[]> generate(ZipInputStream implementation, String format) {
        if (!"interactive".equalsIgnoreCase(format)) {
            throw new AdapterException(Messages.getString("formatNotSupported"));
        }
        HashMap<String, byte[]> output = new HashMap<String, byte[]>();
        this.attachImplementation(implementation, output);
        output.put("definition.xml", this.definition.asXML().getBytes(Charsets.UTF_8));
        return output;
    }

    private void attachImplementation(ZipInputStream implementation, Map<String, byte[]> output) {
        try {
            ZipEntry entry = implementation.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                byte[] file = IOUtils.toByteArray((InputStream)implementation);
                output.put(name, file);
                entry = implementation.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new AdapterException("Error processing interactive output", (Throwable)e);
        }
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
    }

    public void setBundleName(String bundleId) {
    }

    public String getBundleName() {
        return null;
    }

    public Map<String, byte[]> generate(JSONObject definition, String baseFolder, String format, Map<String, String> headers) {
        return null;
    }

    public void setLocale(Locale lc) {
    }
}

