/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.definition;

import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.VisualizationException;
import com.ibm.ba.vis.service.definition.ChartTypeDefinitionProxy;
import com.ibm.ba.vis.service.definition.Definition;
import com.ibm.ba.vis.service.definition.DefinitionFactory;
import com.ibm.ba.vis.service.definition.VidaDefinition;
import com.ibm.ba.vis.service.definition.VidaDefinitionProxy;
import com.ibm.ba.vis.service.definition.VisualizatioDefinitionProxy;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.ChartTypeDefinition;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.VisualizationDefinition;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisDefinitionFactory
implements DefinitionFactory {
    private static final Logger logger = LoggerFactory.getLogger(VisDefinitionFactory.class);
    private static final String DEFINITION_V1 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1";
    private static final String DEFINITION_V2 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2";
    private static final String DEFINITION_V3 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3";
    private static final String DEFINITION_V3_1 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1";
    private final JAXBContext context;

    public VisDefinitionFactory() {
        try {
            this.context = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1");
        }
        catch (JAXBException e) {
            throw new VisualizationException("Error creating jaxb instance for com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3:com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1", e);
        }
    }

    VisDefinitionFactory(JAXBContext context) {
        this.context = context;
    }

    @Override
    public Definition getDefinition(InputStream definition) {
        try {
            String raw = IOUtils.toString((InputStream)definition, (Charset)Charsets.UTF_8);
            logger.debug("getDefinition - XML data: " + raw.toString());
            Unmarshaller um = this.context.createUnmarshaller();
            Object defObj = um.unmarshal((Source)new StreamSource(new StringReader(raw)));
            if (defObj instanceof ChartTypeDefinition) {
                return new ChartTypeDefinitionProxy((ChartTypeDefinition)defObj, raw);
            }
            if (defObj instanceof VisualizationDefinition) {
                return new VisualizatioDefinitionProxy((VisualizationDefinition)defObj, raw);
            }
            throw new VisualizationException(Messages.getString("invalidChartDefinitionXML"));
        }
        catch (Exception e) {
            String errorMsg = Messages.getString("invalidChartDefinitionXML");
            throw new VisualizationException(errorMsg, e);
        }
    }

    @Override
    public Definition getDefinition(JSONObject definition) {
        return new VidaDefinitionProxy(new VidaDefinition(definition));
    }
}

