/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.gallery;

import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.gallery.Gallery;
import com.ibm.ba.vis.service.gallery.GalleryException;
import com.ibm.ba.vis.service.gallery.HttpMethodFactory;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CognosGalleryHttpClient
implements Gallery {
    private static final Logger logger = LoggerFactory.getLogger(CognosGalleryHttpClient.class);
    private static final String DEFINITION_VERSION = "application/vnd.vis.ibm.com.definition.2+xml";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String BUNDLE_ID_PATH_INFO = "/vis/gallery/id/";
    private static final String IMPLEMENTATION = "/implementation";
    private static final String DEFINITION = "/definition";
    private final String dispatcherUrl;
    private final HttpClient client;
    private final HttpMethodFactory factory;
    private final String camPassport;

    public CognosGalleryHttpClient(String dispatcherUrl, String camPassport, HttpClient client) {
        this(dispatcherUrl, camPassport, client, HttpMethodFactory.instance());
    }

    CognosGalleryHttpClient(String dispatcherUrl, String camPassport, HttpClient client, HttpMethodFactory methodFactory) {
        this.dispatcherUrl = dispatcherUrl;
        this.camPassport = camPassport;
        this.client = client;
        this.factory = methodFactory;
    }

    @Override
    public ZipInputStream getImplementation(String chartId) throws GalleryException {
        String uri = this.dispatcherUrl + BUNDLE_ID_PATH_INFO + chartId + IMPLEMENTATION + "?fmt=zip";
        GetMethod method = this.factory.newGetMethod(uri);
        return new ZipInputStream(this.execute(method));
    }

    @Override
    public InputStream getDefinition(String chartId) throws GalleryException {
        String uri = this.dispatcherUrl + BUNDLE_ID_PATH_INFO + chartId + DEFINITION;
        logger.debug("getDefinition - uri: " + uri.toString());
        GetMethod method = this.factory.newGetMethod(uri);
        method.setRequestHeader(ACCEPT_HEADER, DEFINITION_VERSION);
        return this.execute(method);
    }

    private InputStream execute(GetMethod method) throws GalleryException {
        try {
            method.setRequestHeader("Cookie", "cam_passport=" + this.camPassport);
            int status = this.client.executeMethod((HttpMethod)method);
            if (status != 200) {
                String msg = Messages.getString("failedToConnectToGallery");
                throw new GalleryException(msg + " " + "[" + status + "] " + method.getResponseBodyAsString());
            }
            ByteArrayInputStream response = new ByteArrayInputStream(method.getResponseBody());
            return response;
        }
        catch (IOException e) {
            throw new GalleryException(Messages.getString("failedToConnectToGallery"), e);
        }
    }

    @Override
    public JSONObject getDefinitionJSON(String chartId) throws GalleryException {
        return null;
    }

    @Override
    public String getFolder() {
        return null;
    }
}

