/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.gallery;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.ba.vis.schema.definition.Rave2BundleDefinitionManager;
import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.gallery.CognosGallery;
import com.ibm.ba.vis.service.gallery.Gallery;
import com.ibm.ba.vis.service.gallery.GalleryException;
import com.ibm.json.java.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public class FileGallery
implements Gallery {
    private String rootFolderRave1 = "/templates/rsvp/test_bundles/";
    private String rootFolder = null;

    public FileGallery(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Override
    public JSONObject getDefinitionJSON(String chartId) throws GalleryException {
        if (this.isVidaChart(chartId)) {
            CognosGallery gallery = new CognosGallery(null, this.rootFolder, null, null);
            return gallery.getDefinitionJSON(chartId);
        }
        return null;
    }

    @Override
    public ZipInputStream getImplementation(String chartId) throws GalleryException {
        if (this.isVidaChart(chartId) || this.isRave2Chart(chartId)) {
            return null;
        }
        String folder = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.rootFolder + this.rootFolderRave1 + chartId + "/implementation.zip");
        File impl = new File(folder);
        try {
            return new ZipInputStream(new FileInputStream(impl));
        }
        catch (FileNotFoundException e) {
            throw new GalleryException(Messages.getString("Bundle not found"), e);
        }
    }

    @Override
    public InputStream getDefinition(String chartId) throws GalleryException {
        InputStream definitionStream = null;
        try {
            if (this.isVidaChart(chartId)) {
                return null;
            }
            if (this.isRave2Chart(chartId)) {
                String definition = Rave2BundleDefinitionManager.getOneLangRave2OneBundleDefinition((String)chartId, (String)"en");
                definitionStream = new ByteArrayInputStream(definition.getBytes("UTF-8"));
            } else {
                String folder = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.rootFolder + this.rootFolderRave1 + chartId + "/definition.xml");
                File definitionFile = new File(folder);
                definitionStream = new BufferedInputStream(new FileInputStream(definitionFile));
            }
        }
        catch (FileNotFoundException e) {
            throw new GalleryException(Messages.getString("Bundle not found"), e);
        }
        catch (Exception e) {
            throw new GalleryException(Messages.getString("Bundle not found"), e);
        }
        return definitionStream;
    }

    @Override
    public String getFolder() {
        return this.rootFolder;
    }

    private boolean isVidaChart(String chartId) {
        return chartId.startsWith("com.ibm.vis");
    }

    private boolean isRave2Chart(String chartId) {
        return chartId.startsWith("rave-library-") && chartId.contains(",");
    }
}

