/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.gallery;

import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.gallery.GalleryException;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class VidaGallery {
    private Map<String, JSONObject> vidaChartTypes = new TreeMap<String, JSONObject>();

    public void init(String galleryPath) throws GalleryException {
        StringBuilder vidaChartTypesPath = new StringBuilder(galleryPath);
        vidaChartTypesPath.append("/templates/rsvp/viz/VidaChartTypes.json");
        File vidaChartTypesFile = new File(vidaChartTypesPath.toString());
        if (vidaChartTypesFile.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(vidaChartTypesFile), "UTF-8");
                JSONObject root = OrderedJSONObject.parse((Reader)reader);
                Set entries = root.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    Object obj = entry.getValue();
                    if (!(obj instanceof JSONObject)) continue;
                    this.vidaChartTypes.put(key, (JSONObject)obj);
                }
            }
            catch (IOException e) {
                throw new GalleryException(Messages.getString("failedToConnectToGallery"), e);
            }
        }
    }

    public JSONObject getDefinitionJSON(String chartId) {
        return this.vidaChartTypes.get(chartId);
    }
}

