/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance._3_1;

import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.ba.vis.service.instance.DataSetFormatter;
import com.ibm.ba.vis.service.instance.Instance;
import com.ibm.ba.vis.service.instance.InstanceValueField;
import com.ibm.ba.vis.service.instance._3_1.ColorProperty;
import com.ibm.ba.vis.service.instance._3_1.DataSetInstanceProxy;
import com.ibm.ba.vis.service.instance._3_1.FontProperty;
import com.ibm.ba.vis.service.instance._3_1.VisualizationInstanceDataFormatProxy;
import com.ibm.ba.vis.service.instance._3_1.VisualizationInstanceValueFieldProxy;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.xmlns.prod.ba.visbundle.chartinstance._3_1.RGBA;
import com.ibm.xmlns.prod.ba.visbundle.chartinstance._3_1.VisualizationInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VisualizationInstanceProxy
implements Instance {
    private final VisualizationInstance instance;

    public VisualizationInstanceProxy(VisualizationInstance instance) {
        this.instance = instance;
    }

    @Override
    public String getBundleId() {
        return this.instance.getType();
    }

    @Override
    public Map<String, DataSet> getData() {
        HashMap<String, DataSet> data = new HashMap<String, DataSet>();
        VisualizationInstance.DataSetInstances dataSets = this.instance.getDataSetInstances();
        if (dataSets != null) {
            List dataSetInstances = dataSets.getDataSetInstance();
            for (VisualizationInstance.DataSetInstances.DataSetInstance dataSetInstance : dataSetInstances) {
                DataSetInstanceProxy dataSetInstanceProxy = new DataSetInstanceProxy(dataSetInstance);
                data.put(dataSetInstance.getName(), dataSetInstanceProxy);
            }
        }
        return data;
    }

    private VisualizationInstance.PropertyValues.IntegerValue getIntegerProperty(String name) {
        VisualizationInstance.PropertyValues.IntegerValue result = null;
        VisualizationInstance.PropertyValues values = this.instance.getPropertyValues();
        if (values != null) {
            List propList = values.getStringValueOrIntegerValueOrDecimalValue();
            for (Object property : propList) {
                VisualizationInstance.PropertyValues.IntegerValue value;
                if (!(property instanceof VisualizationInstance.PropertyValues.IntegerValue) || !(value = (VisualizationInstance.PropertyValues.IntegerValue)property).getName().equals(name)) continue;
                result = value;
                break;
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        VisualizationInstance.PropertyValues values = this.instance.getPropertyValues();
        if (values != null) {
            List propList = values.getStringValueOrIntegerValueOrDecimalValue();
            for (Object property : propList) {
                VisualizationInstance.PropertyValues.BooleanValue value;
                if (property instanceof VisualizationInstance.PropertyValues.BooleanValue) {
                    value = (VisualizationInstance.PropertyValues.BooleanValue)property;
                    properties.put(value.getName(), value.isValue());
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.DecimalValue) {
                    value = (VisualizationInstance.PropertyValues.DecimalValue)property;
                    properties.put(value.getName(), "" + value.getValue());
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.StringValue) {
                    value = (VisualizationInstance.PropertyValues.StringValue)property;
                    properties.put(value.getName(), value.getValue());
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.IntegerValue) {
                    value = (VisualizationInstance.PropertyValues.IntegerValue)property;
                    properties.put(value.getName(), "" + value.getValue());
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.EnumValue) {
                    value = (VisualizationInstance.PropertyValues.EnumValue)property;
                    properties.put(value.getName(), value.getValue());
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.ColorValue) {
                    value = (VisualizationInstance.PropertyValues.ColorValue)property;
                    RGBA rgb = value.getRGBA();
                    ColorProperty color = new ColorProperty(rgb.getR(), rgb.getG(), rgb.getB(), rgb.getA().doubleValue());
                    properties.put(value.getName(), color);
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.FontValue) {
                    value = (VisualizationInstance.PropertyValues.FontValue)property;
                    FontProperty font = new FontProperty(value.getFamily(), value.getWeight(), value.getStyle(), value.getSize());
                    properties.put(value.getName(), font);
                    continue;
                }
                if (property instanceof VisualizationInstance.PropertyValues.LengthValue) {
                    value = (VisualizationInstance.PropertyValues.LengthValue)property;
                    boolean isNotSupported = value.getName().equals("area.borderWidth") && value.getValue().endsWith("ex");
                    if (isNotSupported) continue;
                    properties.put(value.getName(), value.getValue());
                    continue;
                }
                if (!(property instanceof VisualizationInstance.PropertyValues.ColorPaletteValue)) continue;
                VisualizationInstance.PropertyValues.ColorPaletteValue palette = (VisualizationInstance.PropertyValues.ColorPaletteValue)property;
                properties.put(palette.getName(), palette.getValue());
            }
        }
        return properties;
    }

    @Override
    public Formatter getFormatter() {
        HashMap<String, InstanceValueField> fields = new HashMap<String, InstanceValueField>();
        VisualizationInstance.DataSetInstances dataSets = this.instance.getDataSetInstances();
        if (dataSets != null) {
            List dataSetInstances = dataSets.getDataSetInstance();
            for (VisualizationInstance.DataSetInstances.DataSetInstance dataSetInstance : dataSetInstances) {
                VisualizationInstance.DataSetInstances.DataSetInstance.DataSetFields dataSetFields = dataSetInstance.getDataSetFields();
                if (dataSetFields == null) continue;
                List oList = dataSetFields.getCategoryFieldOrValueField();
                for (Object o : oList) {
                    if (!(o instanceof VisualizationInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField)) continue;
                    VisualizationInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField field = (VisualizationInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField)o;
                    VisualizationInstanceValueFieldProxy fieldProxy = new VisualizationInstanceValueFieldProxy(field);
                    fields.put(field.getName(), fieldProxy);
                }
            }
        }
        VisualizationInstanceDataFormatProxy formatProxy = new VisualizationInstanceDataFormatProxy(this.instance.getDataFormat());
        DataSetFormatter result = new DataSetFormatter(formatProxy, fields, this.getInstanceLocale());
        VisualizationInstance.PropertyValues.IntegerValue roundingMode = this.getIntegerProperty("roundingMode");
        if (roundingMode != null) {
            result.setNumericRounding(DataSetFormatter.convertToICURounding(roundingMode.getValue().intValue()));
        }
        return result;
    }

    @Override
    public Locale getInstanceLocale() {
        String localeValue = this.instance.getLocale();
        if (localeValue == null || localeValue.length() <= 0) {
            return Locale.getDefault();
        }
        if (localeValue.indexOf(95) > 0) {
            return LocaleUtility.getLocaleFromName((String)localeValue);
        }
        return Locale.forLanguageTag(localeValue);
    }
}

