/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance.format;

import com.ibm.ba.vis.service.instance.format.I18NResources;
import com.ibm.ba.vis.service.instance.format.IcuDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.math.BigInteger;
import java.util.Locale;

public class IcuNumberFormat
extends IcuDecimalFormat {
    public IcuNumberFormat(Locale locale, I18NResources resources) {
        super((DecimalFormat)NumberFormat.getNumberInstance((Locale)locale), resources);
    }

    public void setNegativeSign(String sign, Boolean useTrailingSign) {
        DecimalFormatSymbols symbols = this.getFormat().getDecimalFormatSymbols();
        sign = sign == null ? Character.toString(symbols.getMinusSign()) : sign;
        useTrailingSign = useTrailingSign == null ? Boolean.FALSE : useTrailingSign;
        String prefix = "";
        String suffix = "";
        if ("()".equals(sign)) {
            prefix = prefix + "(";
            suffix = suffix + ")";
        } else if (useTrailingSign.booleanValue()) {
            suffix = suffix + sign;
        } else {
            prefix = prefix + sign;
        }
        this.getFormat().setNegativePrefix(prefix);
        this.getFormat().setNegativeSuffix(suffix);
    }

    public void setUseScientific(Boolean value) {
        if (value != null) {
            this.getFormat().setScientificNotation(value.booleanValue());
        }
    }

    public void setExponentSize(BigInteger value) {
        if (value != null) {
            this.getFormat().setMaximumFractionDigits(value.intValue());
        }
    }

    public void setExponentSymbol(String value) {
        if (value != null) {
            DecimalFormatSymbols symbols = this.getFormat().getDecimalFormatSymbols();
            symbols.setExponentSeparator(value);
            this.getFormat().setDecimalFormatSymbols(symbols);
        }
    }
}

