/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance.format;

import com.ibm.ba.vis.service.instance.format.I18NResources;
import com.ibm.ba.vis.service.instance.format.IcuDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.math.BigInteger;
import java.util.Locale;

public class IcuPercentFormat
extends IcuDecimalFormat {
    private BigInteger percentScale = new BigInteger("0");

    public IcuPercentFormat(Locale locale, I18NResources resources) {
        super((DecimalFormat)NumberFormat.getPercentInstance((Locale)locale), resources);
    }

    @Override
    int getScale() {
        return this.percentScale.intValue();
    }

    public void setPercentFormat(String sign, Boolean useTrailingSign, String percentSymbol) {
        DecimalFormatSymbols symbols = this.getFormat().getDecimalFormatSymbols();
        sign = sign == null ? Character.toString(symbols.getMinusSign()) : sign;
        percentSymbol = percentSymbol == null ? Character.toString(symbols.getPercent()) : percentSymbol;
        useTrailingSign = useTrailingSign == null ? Boolean.FALSE : useTrailingSign;
        this.setNegativeFormat(sign, useTrailingSign, percentSymbol);
        this.setPositiveFormat(percentSymbol);
    }

    private void setNegativeFormat(String sign, Boolean useTrailingSign, String percentSymbol) {
        String prefix = "";
        String suffix = "";
        if ("()".equals(sign)) {
            prefix = prefix + "(";
            suffix = suffix + percentSymbol + ")";
        } else {
            if (useTrailingSign.booleanValue()) {
                suffix = suffix + sign;
            } else {
                prefix = prefix + sign;
            }
            suffix = suffix + percentSymbol;
        }
        this.getFormat().setNegativePrefix(prefix);
        this.getFormat().setNegativeSuffix(suffix);
    }

    private void setPositiveFormat(String percentSymbol) {
        this.getFormat().setPositiveSuffix(percentSymbol);
        this.getFormat().setPositivePrefix("");
    }
}

