/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.IXQEReference;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.XQENodeTypeEnum;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.HashMap;
import java.util.Map;

public abstract class XQENodeFactory
implements IXQENodeFactory {
    protected XQEIDGenerator mIdGenerator;
    protected IPlanningEnvironment environment;
    protected XQETrace mTrace;

    @Override
    public final IXQEQueryNode createNode(int type) {
        IXQEQueryNode node = this.componentCreateNode(type);
        if (node != null) {
            node.setNodeId(this.mIdGenerator.getNextID());
            node.setPlanningEnvironment(this.environment);
            node.saveNodeType(type);
        }
        return node;
    }

    @Override
    public final IXQEQueryNode createXNode(int type) {
        IXQEQueryNode node = this.componentCreateNode(type);
        if (node != null) {
            node.setNodeId(this.mIdGenerator.getNextID());
            node.setPlanningEnvironment(this.environment);
            node.saveNodeType(type);
        }
        return node;
    }

    public IXQEQueryNode createNodeByName(String name) {
        return null;
    }

    protected abstract IXQEQueryNode componentCreateNode(int var1);

    @Override
    public IXQEQueryNode createNode(String name) {
        return null;
    }

    @Override
    public IXQEQueryNode createNode(int type, IXQEQueryNode node) {
        IXQEQueryNode result = this.createNode(type);
        if (node != null) {
            ((XQEBaseQueryNode)node).copyLineageToNode(result);
        }
        return result;
    }

    @Override
    public XQENodeIndex getNodeIndex() {
        return this.environment.getNodeIndex();
    }

    public void setPlanningEnvironment(IPlanningEnvironment theEnvironment) {
        this.environment = theEnvironment;
    }

    @Override
    public void setTrace(XQETrace trace) {
        this.mTrace = trace;
    }

    @Override
    public IXQEQueryNode deepCopyNode(IXQEQueryNode node) {
        HashMap<IXQEQueryNode, IXQEQueryNode> mapOriginalToNew = new HashMap<IXQEQueryNode, IXQEQueryNode>();
        IXQEQueryNode copiedNode = this.deepCopyNode(node, mapOriginalToNew);
        for (Map.Entry origToNewEntry : mapOriginalToNew.entrySet()) {
            IXQEQueryNode newDef;
            IXQEQueryNode originalRef = (IXQEQueryNode)origToNewEntry.getKey();
            if (!(originalRef instanceof IXQEReference) || (newDef = (IXQEQueryNode)mapOriginalToNew.get(((IXQEReference)originalRef).getDefinition())) == null) continue;
            ((IXQEReference)origToNewEntry.getValue()).setDefinition(newDef);
        }
        copiedNode.resolveValueOfQueryNodeProperties(mapOriginalToNew);
        return copiedNode;
    }

    private IXQEQueryNode deepCopyNode(IXQEQueryNode node, Map<IXQEQueryNode, IXQEQueryNode> mapOriginalToNew) {
        IXQEQueryNode copiedNode = this.copyNode(node);
        IXQEQueryNode newChild = null;
        mapOriginalToNew.put(node, copiedNode);
        for (IXQEQueryNode child : node.getChildren()) {
            newChild = this.deepCopyNode(child, mapOriginalToNew);
            copiedNode.addChildNonIndexed(newChild);
        }
        return copiedNode;
    }

    public IXQEQueryNode deepCopyNodeNonIndexed(QTEQueryNode node) {
        IXQEQueryNode copiedNode = this.copyNode((IXQEQueryNode)node);
        copiedNode.setNodeIndex(null);
        IXQEQueryNode newChild = null;
        for (QTEQueryNode child : node.getChildren()) {
            newChild = this.deepCopyNodeNonIndexed(child);
            copiedNode.addChildNonIndexed(newChild);
        }
        return copiedNode;
    }

    @Override
    public IXQEQueryNode copyNode(IXQEQueryNode node) {
        IXQEQueryNode copiedNode = this.createNode(node.getType());
        if (node.getType() == copiedNode.getType()) {
            node.copyContentTo(this, copiedNode);
        }
        return copiedNode;
    }

    @Override
    public String getNodeTypeName(int type) {
        return XQENodeTypeEnum.getNodeTypeName(type);
    }

    @Override
    public abstract int getLowNodeID();

    @Override
    public abstract int getHighNodeID();

    public void setNodeIDGenerator(XQEIDGenerator idGenerator) {
        this.mIdGenerator = idGenerator;
    }

    public XQEIDGenerator getNodeIdGenerator() {
        return this.mIdGenerator;
    }

    public int getLastNodeIDGenerated() {
        return this.mIdGenerator.getLastID();
    }

    @Override
    public V5QueryNode createV5Node(String name) {
        throw new UnsupportedOperationException();
    }

    public V5QueryNode createV5ExpNode(String name) {
        throw new UnsupportedOperationException();
    }
}

