/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class XQEPersistContext {
    private static final String STRING_PROPERTY_VALUE = "value";
    public static final String STRING_PROPERTY_ENTRY = "entry";
    private static final String STRING_HASHMAP = "HashMap";
    private static final String STRING_TREEMAP = "TreeMap";
    private static final String STRING_PREFIX_ELEMENT_REF = "r:REF";
    private static final String STRING_PROPERTY_NAME = "name";
    private static final String STRING_PREFIX_ELEMENT_NULL = "n:NULL";
    private List<IXQEPersist> objects = new ArrayList<IXQEPersist>();
    private XMLWriter writer = null;

    public XQEPersistContext(XMLWriter writeto) {
        this.writer = writeto;
    }

    public XMLWriter getWriter() {
        return this.writer;
    }

    public void add(IXQEPersist node) {
        this.objects.add(node);
    }

    public int indexOf(IXQEPersist node) {
        int result = -1;
        Iterator<IXQEPersist> iter = this.objects.iterator();
        int index = 0;
        while (result == -1 && iter.hasNext()) {
            IXQEPersist obj = iter.next();
            if (node == obj) {
                result = index;
                continue;
            }
            ++index;
        }
        return result;
    }

    public IXQEPersist get(int index) {
        return this.objects.get(index);
    }

    protected String getPersistName(boolean asProperty) {
        String result = this.getClass().getName();
        int index = result.lastIndexOf(46);
        if (index != -1) {
            result = result.substring(index + 1);
        }
        if (asProperty) {
            StringBuilder builder = new StringBuilder("x:");
            builder.append(result);
            result = builder.toString();
        }
        return result;
    }

    public boolean beginElement(IXQEPersist node, String optionalName, int id) {
        boolean result = true;
        String name = optionalName != null || !(node instanceof IXQEQueryNode) ? this.getPropName(null, node) : this.getPropName(null, node, "");
        int pid = this.indexOf(node);
        if (pid == -1) {
            this.add(node);
            this.writer.beginElement(name, id);
            this.writer.attribute("pid", this.objects.size());
            if (optionalName != null) {
                this.writer.attribute("pname", optionalName);
            }
        } else {
            if (optionalName != null || !(node instanceof IXQEQueryNode)) {
                this.writer.beginElement(STRING_PREFIX_ELEMENT_REF, -1);
            } else {
                this.writer.beginElement("REF", -1);
            }
            this.writer.attribute("ref", pid + 1);
            if (optionalName != null) {
                this.writer.attribute("pname", optionalName);
            }
            this.writer.endElement();
            result = false;
        }
        return result;
    }

    public void endElement() {
        this.writer.endElement();
    }

    public void attribute(String name, String value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, int value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, long value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, float value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, double value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, boolean value) {
        this.writer.attribute(name, value);
    }

    public void attribute(String name, Object value) {
        this.writer.attribute(name, value);
    }

    public void data(String data) {
        this.writer.data(data);
    }

    public void cdata(String data) {
        this.writer.cdata(data);
    }

    public void xml(String data) {
        this.writer.xml(data);
    }

    public String getPropName(String key, Object value) {
        String prefix = null;
        prefix = value == null ? "n:" : (value instanceof Integer ? "i:" : (value instanceof Long ? "l:" : (value instanceof String ? "s:" : (value instanceof Boolean ? "b:" : (value instanceof Double ? "d:" : (value instanceof IDataType ? "dt:" : (value instanceof FDSDataTypeEnum ? "fdt:" : (value instanceof SQLSortKey.NullOrdering ? "no:" : (value instanceof XJoin.JoinType ? "jt:" : (value instanceof ICube ? "cb:" : (value instanceof IMetadata ? "md:" : (value instanceof IXQEQueryNode ? "x:" : (value instanceof IXQEPersist ? "p:" : (value instanceof Locale ? "lcl:" : (value instanceof V5RollupAggregateEnum ? "ra:" : "o:")))))))))))))));
        return this.getPropName(key, value, prefix);
    }

    public String getPropName(String key, Object value, String prefix) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        if (key != null) {
            builder.append(key);
        } else {
            String name = value.getClass().getSimpleName();
            if (name.contains("[]")) {
                name = name.replace("[]", "-array");
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public void property(String key, Object value) {
        this.property(key, value, null);
    }

    public void property(String key, Object value, String prefix) {
        String name = prefix != null ? this.getPropName(key, value, prefix) : this.getPropName(key, value);
        if (value != null) {
            if (value instanceof ICube) {
                ICube cb = (ICube)value;
                this.writer.attribute(name, cb.getName());
            } else if (value instanceof IMetadata) {
                IMetadata md = (IMetadata)value;
                if (md.getID() != null) {
                    this.writer.attribute(name, md.getID());
                }
            } else if (value instanceof FDSDataTypeEnum) {
                FDSDataTypeEnum dt = (FDSDataTypeEnum)((Object)value);
                this.writer.attribute(name, dt.toFDSKeyword());
            } else if (value instanceof SQLSortKey.NullOrdering) {
                SQLSortKey.NullOrdering no = (SQLSortKey.NullOrdering)((Object)value);
                this.writer.attribute(name, no.toString());
            } else if (value instanceof XJoin.JoinType) {
                XJoin.JoinType jt = (XJoin.JoinType)((Object)value);
                this.writer.attribute(name, jt.getDescriptor());
            } else if (value instanceof Locale) {
                Locale locale = (Locale)value;
                this.writer.attribute(name, locale.toString());
            } else if (value instanceof V5RollupAggregateEnum) {
                V5RollupAggregateEnum ra = (V5RollupAggregateEnum)value;
                this.writer.attribute(name, ra.getName());
            } else {
                this.writer.attribute(name, value);
            }
        } else {
            this.writer.attribute(name, "null");
        }
    }

    public void elementProperty(String key, Object value) {
        if (value == null) {
            this.writer.beginElement(STRING_PREFIX_ELEMENT_NULL, -1);
            if (key != null) {
                this.attribute("pname", key);
            }
            this.endElement();
        } else if (value instanceof IXQEQueryNode) {
            IXQEQueryNode node = (IXQEQueryNode)value;
            node.persist(this, key);
        } else if (value instanceof IXQEPersist) {
            IXQEPersist node = (IXQEPersist)value;
            node.persist(this, key);
        } else {
            String name = this.getPropName(null, value);
            this.writer.beginElement(name, -1);
            if (key != null) {
                this.attribute("pname", key);
            }
            this.propertyValue(value);
            this.writer.endElement();
        }
    }

    public void propertyValue(Object value) {
        if (value instanceof String) {
            this.cdata((String)value);
        } else if (value instanceof Boolean) {
            this.attribute(STRING_PROPERTY_VALUE, (Boolean)value);
        } else if (value instanceof Integer) {
            this.attribute(STRING_PROPERTY_VALUE, (Integer)value);
        } else if (value instanceof Double) {
            this.attribute(STRING_PROPERTY_VALUE, (Double)value);
        } else if (value instanceof IDataType) {
            this.attribute(STRING_PROPERTY_VALUE, ((IDataType)value).toString());
        } else if (value instanceof FDSDataTypeEnum) {
            this.attribute(STRING_PROPERTY_VALUE, ((FDSDataTypeEnum)((Object)value)).toFDSKeyword());
        } else if (value instanceof SQLSortKey.NullOrdering) {
            this.attribute(STRING_PROPERTY_VALUE, ((SQLSortKey.NullOrdering)((Object)value)).toString());
        } else if (value instanceof XJoin.JoinType) {
            this.attribute(STRING_PROPERTY_VALUE, ((XJoin.JoinType)((Object)value)).getDescriptor());
        } else if (value instanceof Locale) {
            this.attribute(STRING_PROPERTY_VALUE, ((Locale)value).toString());
        } else if (value instanceof V5RollupAggregateEnum) {
            this.attribute(STRING_PROPERTY_VALUE, ((V5RollupAggregateEnum)value).getName());
        } else if (value instanceof ICube) {
            ICube cb = (ICube)value;
            this.attribute(STRING_PROPERTY_VALUE, cb.getName());
        } else if (value instanceof IMetadata) {
            this.attribute(STRING_PROPERTY_VALUE, ((IMetadata)value).getID());
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object val : list) {
                this.elementProperty(null, val);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                this.writer.beginElement(STRING_PROPERTY_ENTRY, -1);
                this.elementProperty(null, entry.getKey());
                this.elementProperty(null, entry.getValue());
                this.writer.endElement();
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            for (Object val : set) {
                this.elementProperty(null, val);
            }
        } else if (value instanceof Object[]) {
            Object[] values;
            for (Object val : values = (Object[])value) {
                this.elementProperty(null, val);
            }
        } else if (value instanceof int[]) {
            int[] values;
            for (int val : values = (int[])value) {
                this.elementProperty(null, val);
            }
        } else if (value instanceof boolean[]) {
            boolean[] values;
            for (boolean val : values = (boolean[])value) {
                this.elementProperty(null, val);
            }
        } else if (value instanceof Element) {
            Element element = (Element)value;
            this.writer.writeXML(element.asXML());
        } else {
            String name = this.getPropName(null, value);
            this.writer.beginElement(name, -1);
            this.writer.endElement();
        }
    }

    public boolean isSimpleType(Object value) {
        return value == null || value instanceof String || value instanceof Integer || value instanceof Boolean || value instanceof Double || value instanceof IDataType || value instanceof ICube || value instanceof IMetadata || value instanceof FDSDataTypeEnum || value instanceof SQLSortKey.NullOrdering || value instanceof XJoin.JoinType || value instanceof Locale || value instanceof V5RollupAggregateEnum;
    }
}

