/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEPersistCreate;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistCreate;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class XQERestoreContext {
    private static final String STRING_HASHMAP = "HashMap";
    private static final String STRING_TREEMAP = "TreeMap";
    private PlanningEnvironment planEnv = null;
    private Map<Integer, IXQEPersist> objects = new TreeMap<Integer, IXQEPersist>();
    private List<IXQEPersist> ownerNodes = new ArrayList<IXQEPersist>();
    private XQEPersistCreate defaultCreator = new XQEPersistCreate();

    public XQERestoreContext(PlanningEnvironment env) {
        this.planEnv = env;
    }

    public PlanningEnvironment getPlanningEnvironment() {
        return this.planEnv;
    }

    public void setPlanningEnvironment(PlanningEnvironment env) {
        this.planEnv = env;
    }

    public IXQEPersist getOwnerNode() {
        IXQEPersist result = null;
        if (this.ownerNodes.size() > 0) {
            result = this.ownerNodes.get(this.ownerNodes.size() - 1);
        }
        return result;
    }

    public List<IXQEPersist> getOwnerNodes() {
        return this.ownerNodes;
    }

    public void setOwner(IXQEPersist ownerNode) {
        this.ownerNodes.add(ownerNode);
    }

    public void resetOwner() {
        this.ownerNodes.remove(this.ownerNodes.size() - 1);
    }

    public boolean isReference(Element child) {
        boolean result = false;
        if (child.getNamespace().getURI().equals("http://developer.cognos.com/Types/Reference") || child.getName().equals("REF")) {
            result = true;
        }
        return result;
    }

    public IXQEPersist createNode(Element child) {
        IXQEPersist result = null;
        if (this.isReference(child)) {
            result = this.objects.get(Integer.valueOf(child.attributeValue("ref")));
        } else {
            Integer pid = Integer.valueOf(child.attributeValue("pid"));
            XQENodeFactory factory = this.planEnv.getNodeFactory();
            result = factory.createNodeByName(child.getName());
            if (result != null) {
                this.objects.put(pid, result);
            }
        }
        return result;
    }

    public IXQEPersist createPersistNode(Element child, IXQEPersistCreate iCreate) {
        IXQEPersist result = null;
        if (this.isReference(child)) {
            Integer pid = Integer.valueOf(child.attributeValue("ref"));
            result = this.objects.get(pid);
        } else {
            Integer pid = Integer.valueOf(child.attributeValue("pid"));
            result = iCreate.create(this, child);
            if (result != null) {
                this.objects.put(pid, result);
            }
        }
        return result;
    }

    public Object attributeValue(Attribute att) {
        Object result = null;
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/null")) {
            result = null;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/String")) {
            result = att.getValue();
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Integer")) {
            result = Integer.valueOf(att.getValue());
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Long")) {
            result = Long.valueOf(att.getValue());
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Boolean")) {
            result = Boolean.valueOf(att.getValue());
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Double")) {
            result = Double.valueOf(att.getValue());
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IDataType")) {
            IDataType dataType = DataTypeFactory.getType(att.getValue());
            result = dataType;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/FDSDataTypeEnum")) {
            FDSDataTypeEnum dataType = FDSDataTypeEnum.fromFDS(att.getValue());
            result = dataType;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/NullOrdering")) {
            SQLSortKey.NullOrdering nullOrdering = null;
            for (SQLSortKey.NullOrdering val : SQLSortKey.NullOrdering.values()) {
                if (!val.name().equals(att.getValue())) continue;
                nullOrdering = val;
                break;
            }
            result = nullOrdering;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/JoinType")) {
            XJoin.JoinType joinType = null;
            for (XJoin.JoinType val : XJoin.JoinType.values()) {
                if (!val.getDescriptor().equals(att.getValue())) continue;
                joinType = val;
                break;
            }
            result = joinType;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/ICube")) {
            MetadataConnection md = this.planEnv.getMetadataConnection();
            result = md.getCube(att.getValue());
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IMetadata")) {
            MetadataConnection md = this.planEnv.getMetadataConnection();
            IMetadata metadata = md.bindMetadataReference(att.getValue());
            result = metadata;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Locale")) {
            Locale value = new Locale(att.getValue());
            result = value;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Locale")) {
            V5RollupAggregateEnum value = V5RollupAggregateEnum.valueOfV5String(att.getValue());
            result = value;
        }
        return result;
    }

    public Object elementValue(Element node) {
        return this.elementValue(node, this.defaultCreator);
    }

    public Object elementValue(Element node, IXQEPersistCreate iCreate) {
        Object result = null;
        String localName = node.getName();
        Namespace ns = node.getNamespace();
        if (this.isReference(node)) {
            Integer ref = Integer.valueOf(node.attributeValue("ref"));
            result = this.objects.get(ref);
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IXQEQueryNode")) {
            IXQEQueryNode child = (IXQEQueryNode)this.createNode(node);
            if (!this.isReference(node)) {
                child.restore(this, node);
            }
            result = child;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IXQEPersist")) {
            IXQEPersist child = this.createPersistNode(node, iCreate);
            result = child;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/ICube")) {
            MetadataConnection md = this.planEnv.getMetadataConnection();
            result = md.getCube(node.attributeValue("value"));
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IMetadata")) {
            MetadataConnection md = this.planEnv.getMetadataConnection();
            IMetadata metadata = md.bindMetadataReference(node.attributeValue("value"));
            result = metadata;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/IDataType")) {
            IDataType dataType = DataTypeFactory.getType(node.attributeValue("value"));
            result = dataType;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/FDSDataTypeEnum")) {
            FDSDataTypeEnum dataType = FDSDataTypeEnum.fromFDS(node.attributeValue("value"));
            result = dataType;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/NullOrdering")) {
            String attValue = node.attributeValue("value");
            for (SQLSortKey.NullOrdering val : SQLSortKey.NullOrdering.values()) {
                if (!val.name().equals(attValue)) continue;
                result = val;
                break;
            }
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/JoinType")) {
            String attValue = node.attributeValue("value");
            for (XJoin.JoinType val : XJoin.JoinType.values()) {
                if (!val.getDescriptor().equals(attValue)) continue;
                result = val;
                break;
            }
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/Locale")) {
            String attValue = node.attributeValue("value");
            Locale value = new Locale(attValue);
            result = value;
        } else if (ns.getURI().equals("http://developer.cognos.com/Types/V5RollupAggregateEnum")) {
            String attValue = node.attributeValue("value");
            V5RollupAggregateEnum value = V5RollupAggregateEnum.valueOfV5String(attValue);
            result = value;
        } else if (localName.equals("String")) {
            String val = null;
            Iterator iter = node.nodeIterator();
            while (iter.hasNext()) {
                Node child = (Node)iter.next();
                if (child.getNodeType() != 4) continue;
                val = child.getText();
            }
            result = val;
        } else if (localName.equals("Boolean")) {
            String val = node.attributeValue("value");
            if (val != null) {
                result = Boolean.valueOf(val);
            }
        } else if (localName.equals("Integer")) {
            String val = node.attributeValue("value");
            if (val != null) {
                result = Integer.valueOf(val);
            }
        } else if (localName.equals("Long")) {
            String val = node.attributeValue("value");
            if (val != null) {
                result = Long.valueOf(val);
            }
        } else if (localName.equals("Double")) {
            String val = node.attributeValue("value");
            if (val != null) {
                result = Double.valueOf(val);
            }
        } else if (localName.equals("ArrayList")) {
            ArrayList<Object> list = new ArrayList<Object>();
            List childList = node.elements();
            int nChildren = childList.size();
            for (int index = 0; index < nChildren; ++index) {
                Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                if (childValue == null) continue;
                list.add(childValue);
            }
            result = list;
        } else if (localName.equals("LinkedList")) {
            LinkedList<Object> list = new LinkedList<Object>();
            List childList = node.elements();
            int nChildren = childList.size();
            for (int index = 0; index < nChildren; ++index) {
                Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                if (childValue == null) continue;
                list.add(childValue);
            }
            result = list;
        } else if (localName.equals("HashSet")) {
            HashSet<Object> list = new HashSet<Object>();
            List childList = node.elements();
            int nChildren = childList.size();
            for (int index = 0; index < nChildren; ++index) {
                Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                if (childValue == null) continue;
                list.add(childValue);
            }
            result = list;
        } else if (localName.equals(STRING_HASHMAP) || localName.equals(STRING_TREEMAP)) {
            AbstractMap map = localName.equals(STRING_HASHMAP) ? new HashMap() : new TreeMap();
            List childList = node.elements();
            int nChildren = childList.size();
            for (int index = 0; index < nChildren; ++index) {
                Element entry = (Element)childList.get(index);
                List entryList = entry.elements();
                if (entryList.size() != 2) continue;
                Object key = this.elementValue((Element)entryList.get(0), iCreate);
                Object val = this.elementValue((Element)entryList.get(1), iCreate);
                if (key == null) continue;
                map.put(key, val);
            }
            result = map;
        } else if (localName.equals("IXQEQueryNode-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                IXQEQueryNode[] array = new IXQEQueryNode[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (IXQEQueryNode)childValue;
                }
                result = array;
            }
        } else if (localName.equals("OrderBy-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                OrderBy[] array = new OrderBy[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (OrderBy)childValue;
                }
                result = array;
            }
        } else if (localName.equals("XExpression-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                XExpression[] array = new XExpression[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (XExpression)childValue;
                }
                result = array;
            }
        } else if (localName.equals("XVectorExpression-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                XVectorExpression[] array = new XVectorExpression[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (XVectorExpression)childValue;
                }
                result = array;
            }
        } else if (localName.equals("RSAPIDataItem-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                RSAPIDataItem[] array = new RSAPIDataItem[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (RSAPIDataItem)childValue;
                }
                result = array;
            }
        } else if (localName.equals("XSetFunction-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                XSetFunction[] array = new XSetFunction[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (XSetFunction)childValue;
                }
                result = array;
            }
        } else if (localName.equals("WindowDescriptor-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                WindowDescriptor[] array = new WindowDescriptor[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (WindowDescriptor)childValue;
                }
                result = array;
            }
        } else if (localName.equals("NullOrdering-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                SQLSortKey.NullOrdering[] array = new SQLSortKey.NullOrdering[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (SQLSortKey.NullOrdering)((Object)childValue);
                }
                result = array;
            }
        } else if (localName.equals("Parameter-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                Parameter[] array = new Parameter[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (Parameter)childValue;
                }
                result = array;
            }
        } else if (localName.equals("String-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                String[] array = new String[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (String)childValue;
                }
                result = array;
            }
        } else if (localName.equals("int-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                int[] array = new int[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (Integer)childValue;
                }
                result = array;
            }
        } else if (localName.equals("long-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                long[] array = new long[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (Long)childValue;
                }
                result = array;
            }
        } else if (localName.equals("boolean-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                boolean[] array = new boolean[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (Boolean)childValue;
                }
                result = array;
            }
        } else if (localName.equals("DataType-array")) {
            List childList = node.elements();
            int nChildren = childList.size();
            if (nChildren > 0) {
                DataType[] array = new DataType[nChildren];
                for (int index = 0; index < nChildren; ++index) {
                    Object childValue = this.elementValue((Element)childList.get(index), iCreate);
                    array[index] = (DataType)childValue;
                }
                result = array;
            }
        } else if (ns.getURI().isEmpty()) {
            IXQEQueryNode child = (IXQEQueryNode)this.createNode(node);
            if (child != null && !this.isReference(node)) {
                child.restore(this, node);
            }
            result = child;
        }
        return result;
    }

    public RSAPIDataset getDataset() {
        RSAPIDataset result = null;
        Iterator<IXQEPersist> iter = this.ownerNodes.iterator();
        while (result == null && iter.hasNext()) {
            IXQEPersist owner = iter.next();
            if (!(owner instanceof RSAPIDataset)) continue;
            result = (RSAPIDataset)owner;
        }
        return result;
    }

    public RSAPIEdge getEdge() {
        RSAPIEdge result = null;
        Iterator<IXQEPersist> iter = this.ownerNodes.iterator();
        while (result == null && iter.hasNext()) {
            IXQEPersist owner = iter.next();
            if (!(owner instanceof RSAPIEdge)) continue;
            result = (RSAPIEdge)owner;
        }
        return result;
    }

    public RSAPIRowset getRowset() {
        RSAPIRowset result = null;
        Iterator<IXQEPersist> iter = this.ownerNodes.iterator();
        while (result == null && iter.hasNext()) {
            IXQEPersist owner = iter.next();
            if (!(owner instanceof RSAPIRowset)) continue;
            result = (RSAPIRowset)owner;
        }
        return result;
    }
}

