/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.checksum;

import com.cognos.xqe.ast.checksum.ICheckSum;
import com.cognos.xqe.ast.checksum.ICheckSummable;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractCheckSum
implements ICheckSum {
    protected String checkSumName = "checksum";
    protected List<CheckSumElement> checkSumElements = new ArrayList<CheckSumElement>();

    @Override
    public void compute(ICheckSummable checkSummable) {
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        if (writer == null) {
            return;
        }
        writer.beginElement(this.checkSumName, -1);
        Collections.sort(this.checkSumElements);
        for (CheckSumElement element : this.checkSumElements) {
            element.toXMLString(writer);
        }
        writer.endElement();
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        Collections.sort(this.checkSumElements);
        for (CheckSumElement element : this.checkSumElements) {
            strBuffer.append(element.toString());
        }
        return strBuffer.toString();
    }

    public void setChecksumName(String checksumName) {
        this.checkSumName = checksumName;
    }

    protected class CheckSumElement
    implements Comparable<Object> {
        protected static final String NODE_TYPE = "nodeType";
        protected static final String OCCURS = "occurs";
        protected static final String ID = "id";
        protected static final String NAME = "name";
        protected SortedMap<String, String> mPropertiesMap = new TreeMap<String, String>();
        private ICheckSummable checkSummable = null;
        private int occurs = 0;

        public CheckSumElement(ICheckSummable aCheckSummable) {
            this.checkSummable = aCheckSummable;
            this.mPropertiesMap = this.checkSummable.getCheckSumPropertiesMap();
        }

        public void toXMLString(XMLWriter writer) {
            if (writer == null) {
                return;
            }
            writer.beginElement(NODE_TYPE, -1);
            writer.attribute(ID, this.getTypeId().toString());
            writer.attribute(NAME, this.checkSummable.getClass().getSimpleName());
            for (Map.Entry<String, String> entry : this.mPropertiesMap.entrySet()) {
                writer.attribute(entry.getKey(), entry.getValue());
            }
            writer.attribute(OCCURS, this.occurs);
            writer.endElement();
        }

        public void incrementOccurs() {
            ++this.occurs;
        }

        public Integer getTypeId() {
            return XQEIntegerPool.getInteger(this.checkSummable.getType());
        }

        protected ICheckSummable getCheckSummable() {
            return this.checkSummable;
        }

        protected int getOccurs() {
            return this.occurs;
        }

        @Override
        public int compareTo(Object checkSumElement) {
            CheckSumElement compare = (CheckSumElement)checkSumElement;
            if (this.getTypeId().intValue() != compare.getTypeId().intValue()) {
                return this.getTypeId().compareTo(compare.getTypeId());
            }
            return this.toString().compareTo(compare.toString());
        }

        public boolean equals(Object checkSumElement) {
            return checkSumElement != null ? this.hashCode() == checkSumElement.hashCode() : false;
        }

        public int hashCode() {
            String stringRepresentation = this.toString();
            return stringRepresentation.hashCode();
        }

        public String toString() {
            StringBuilder strBuffer = new StringBuilder();
            strBuffer.append(this.getTypeId());
            for (Map.Entry<String, String> entry : this.mPropertiesMap.entrySet()) {
                strBuffer.append(entry.getKey());
                strBuffer.append(entry.getValue());
            }
            return strBuffer.toString();
        }
    }
}

