/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.localprocessing;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import com.cognos.xqe.transformation.runtree.olap.Utility;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOLAPDecoration
extends XQEQueryNode {
    private static final String PROPERTY_EXPLICIT_MEMBER_UNIQUE_NAMES = "explicitMUNs";
    private static final String PROPERTY_EXPLICIT_MEMBERS = "explicitMembers";
    protected static final int MAX_NUM_OF_CHILDREN_UNLIMITED = 65000000;
    protected static final int NUM_OF_CHILDREN_0 = 0;
    protected static final int NUM_OF_CHILDREN_1 = 1;
    protected static final int NUM_OF_CHILDREN_2 = 2;
    protected static final int NUM_OF_CHILDREN_3 = 3;
    public static final int UNKNOWN_VALUE = -1;
    private static final String PROPERTY_EDGE_ORDINAL = "edgeOrdinal";
    private static final String PROPERTY_TUPLE_ORDINAL = "tupleOrdinal";

    @Override
    public int getType() {
        return 601007;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 601007) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int isValidPlannedQuery() {
        return this.getId();
    }

    public void applyCalculatedMemberUNs(MDXQuery mdxQuery) {
        List<AbstractMDXNode> members = this.getExplicitMembers();
        List<MDXCalculatedMemberReference> calculations = this.findAssociatedProjCalculatedMemberRefs(mdxQuery);
        for (MDXCalculatedMemberReference calcRef : calculations) {
            boolean addCalc = true;
            if (!members.contains(calcRef)) {
                for (AbstractMDXNode currMember : members) {
                    if (currMember.getType() != 1013 || ((MDXCalculatedMemberReference)currMember).getDefinition() != calcRef.getDefinition()) continue;
                    addCalc = false;
                    break;
                }
            }
            if (!addCalc) continue;
            members.add(calcRef);
        }
    }

    public List<MDXCalculatedMemberReference> findAssociatedProjCalculatedMemberRefs(MDXQuery mdxQuery) {
        ArrayList<MDXCalculatedMemberReference> associatedCalcRefs = new ArrayList<MDXCalculatedMemberReference>();
        IXQEQueryNode rsapiDataset = this.getAncestorOfType(401005);
        if (mdxQuery == null) {
            IXQEQueryNode[] descMdxQuery = rsapiDataset.getDescendantsOfType(1002, false);
            mdxQuery = (MDXQuery)descMdxQuery[0];
        }
        ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
        IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(mdxQuery);
        int[] nodeTypes = new int[]{1013};
        isProjCalcRef.setNodeTypes(nodeTypes);
        mdxQuery.getDescendantsForCondition(calcRefs, isProjCalcRef, false);
        for (IXQEQueryNode calcRef : calcRefs) {
            if (!((MDXCalculatedMemberReference)calcRef).doesOlapDecorationApply(this)) continue;
            associatedCalcRefs.add((MDXCalculatedMemberReference)calcRef);
        }
        return associatedCalcRefs;
    }

    public void addExplicitMember(AbstractMDXMember abstractMDXMember) {
        List<AbstractMDXNode> members = this.getExplicitMembers();
        if (abstractMDXMember.getType() == 1013) {
            ((MDXCalculatedMemberReference)abstractMDXMember).addOlapDecorationRef(this);
            if (!members.contains(abstractMDXMember)) {
                members.add(abstractMDXMember);
            }
        } else if (!(abstractMDXMember.getType() != 1077 && abstractMDXMember.getType() != 1067 || members.contains(abstractMDXMember))) {
            members.add(abstractMDXMember);
        }
    }

    public List<AbstractMDXNode> getExplicitMembers() {
        ArrayList members = (ArrayList)this.getPropertyValue(PROPERTY_EXPLICIT_MEMBERS);
        if (members == null) {
            members = new ArrayList();
            this.setPropertyValue(PROPERTY_EXPLICIT_MEMBERS, members);
        }
        return members;
    }

    private String getExplicitMUN(AbstractMDXNode abstractMDXMember) {
        String memberUniqueName = null;
        switch (abstractMDXMember.getType()) {
            case 1067: {
                memberUniqueName = ((BaseMember)abstractMDXMember).getUniqueName();
                break;
            }
            case 1013: {
                memberUniqueName = ((MDXCalculatedMemberReference)abstractMDXMember).getUniqueName();
                break;
            }
            case 1077: {
                IMember defaultMember = ((MDXDefaultMember)abstractMDXMember).getHierarchy().getDefaultMember();
                if (null == defaultMember) {
                    this.throwInternalError("null == defaultMember");
                }
                memberUniqueName = defaultMember.getUniqueName();
                break;
            }
            default: {
                StringBuilder errMsg = new StringBuilder("abstractMDXMember.getType() == ");
                errMsg.append(abstractMDXMember.getTypeObject());
                this.throwInternalError(errMsg.toString());
            }
        }
        return memberUniqueName;
    }

    public List<String> getExplicitMUNs() {
        ArrayList<String> names = (ArrayList<String>)this.getPropertyValue(PROPERTY_EXPLICIT_MEMBER_UNIQUE_NAMES);
        if (names == null) {
            names = new ArrayList<String>();
            this.setPropertyValue(PROPERTY_EXPLICIT_MEMBER_UNIQUE_NAMES, names);
            for (AbstractMDXNode member : this.getExplicitMembers()) {
                String mun = this.getExplicitMUN(member);
                if (names.contains(mun)) continue;
                names.add(mun);
            }
        }
        return names;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    public int getMaximumNumberChildren() {
        return 1;
    }

    public void validateChildren() {
        boolean validChildren = this.hasValidChildren();
        if (!validChildren) {
            this.throwInternalError("!validChildren");
        }
    }

    @Override
    public boolean hasValidChildren() {
        int numOfOLAPDecos = this.getChildrenOfCategory(601007).length;
        if (this.getNumberChildren() - numOfOLAPDecos > 1) {
            return false;
        }
        if (this.getNumberChildren() < this.getMinimumNumberChildren()) {
            return false;
        }
        if (this.getNumberChildren() > this.getMaximumNumberChildren()) {
            return false;
        }
        return this.getNumberChildren() - numOfOLAPDecos != 1 || this.getChild(0).getType() == 1002 || Utility.isValidXNodeChild(this.getChild(0));
    }

    public void setEdgeOrdinal(int edgeOrdinal) {
        this.setPropertyValue(PROPERTY_EDGE_ORDINAL, XQEIntegerPool.getInteger(edgeOrdinal));
    }

    public int getEdgeOrdinalProperty() {
        Integer edgeOrdinal = (Integer)this.getPropertyValue(PROPERTY_EDGE_ORDINAL);
        if (edgeOrdinal == null) {
            return -1;
        }
        return edgeOrdinal;
    }

    public void setTupleOrdinal(int tupleOrdinal) {
        this.setPropertyValue(PROPERTY_TUPLE_ORDINAL, XQEIntegerPool.getInteger(tupleOrdinal));
    }

    public int getTupleOrdinalProperty() {
        Integer tupleOrdinal = (Integer)this.getPropertyValue(PROPERTY_TUPLE_ORDINAL);
        if (tupleOrdinal == null) {
            return -1;
        }
        return tupleOrdinal;
    }
}

