/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MAExpressionProcessor;
import com.cognos.xqe.ast.maExp.MAQueryHint;
import com.cognos.xqe.ast.maExp.MAStartAt;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class MAQuery
extends MAQueryNode {
    private List<MACollection> flatCollectionList = null;
    private static final String QUERY_SUBJECT = "querySubject";
    private static final String DIMENSION = "dimension";
    private static final String PROJECT = "project";
    private static final String SHORTCUT = "shortcut";
    protected static final String NAME = "name";
    private static final String CONSTRAINT = "Constraint";
    private static final String BLOCK_CONSTRAINT = "Blockconstraint";
    private static final String CONDITION = "Condition";
    private static final String CASE_SENSITIVE = "CaseSensitive";
    private static final String CONSTRAINTS = "Constraints";
    private static final String PROPERTIES = "Properties";
    private static final String PROPERTY = "Property";
    private static final String PACKAGE = "package";
    private static final String IS_NOT_A_VALID_CHILD_OF = " is not a valid child of ";
    protected static final String START_AT = "Start_at";
    protected static final String START_ATREF = "Start_atRef";
    private static final String START_ATPATH = "Start_atPath";
    protected static final String PATH = "Path";
    private static final String COLLECTION = "./";
    protected XQENodeFactory nodeFactory = null;
    protected PlanningEnvironment environment = null;
    private MetadataConnection metadataConnection = null;

    @Override
    public int getType() {
        return 1101016;
    }

    protected MAQuery() {
    }

    @Override
    public boolean isMemberQuery() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.getChildren()) {
            IXQEQueryNode[] collections;
            if (child.getType() == 1101023) {
                MAQueryHint hint = (MAQueryHint)child;
                if (!hint.getName().equals("RootMembers")) continue;
                return true;
            }
            if (child.getType() != 1101019) continue;
            for (IXQEQueryNode childCollection : collections = child.getDescendantsOfType(1101019, true)) {
                MACollection collection = (MACollection)childCollection;
                if (!collection.getName().equals("member")) continue;
                return true;
            }
        }
        return false;
    }

    public void buildSubtree(PlanningEnvironment env, Element inputNode, boolean defaultCollections) {
        this.nodeFactory = env.getNodeFactory();
        this.environment = env;
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            this.setPropertyValue(attname, att.getValue());
        }
        List containers = inputNode.elements();
        for (Element container : containers) {
            String containerName = container.getName();
            List childrenAll = container.elements();
            List<Element> children = this.filterGarbageProperties(childrenAll);
            if (containerName.equals(PROPERTIES)) {
                this.createPropertiesAndConstraints(children, PROPERTIES, PROPERTY, NAME, false);
                continue;
            }
            if (containerName.equals(CONSTRAINTS)) {
                this.createPropertiesAndConstraints(children, CONSTRAINTS, CONSTRAINT, CONDITION, true);
                continue;
            }
            if (containerName.equals(CONSTRAINT)) {
                XQENodeFactory factory = env.getNodeFactory();
                MAExpressionProcessor maProcessor = new MAExpressionProcessor();
                String expression = container.attributeValue(CONDITION);
                IXQEQueryNode constraintNode = maProcessor.process(expression, factory);
                this.setCaseSensitivity(container, constraintNode);
                this.addChild(constraintNode);
                continue;
            }
            if (containerName.equals(START_ATREF)) {
                this.processStrartingConditions(children, START_ATREF, PATH, NAME);
                continue;
            }
            if (!containerName.equals(START_ATPATH)) continue;
            this.processStrartingConditions(children, START_ATPATH, PATH, NAME);
        }
        if (defaultCollections) {
            this.addMandatoryCollections();
        }
        this.createFlatCollectionList();
    }

    public void createPropertiesAndConstraints(List<Element> children, String parentName, String childName, String attributeValue, boolean checkCaseSensitivity) {
        MAExpressionProcessor maProcessor = new MAExpressionProcessor();
        for (Element child : children) {
            Pattern p;
            Matcher m;
            if (!child.getName().equals(childName)) {
                if (this.isBlockConstraint(parentName, child.getName())) {
                    MABlockConstraint blockConstraintNode = this.addBlockConstraint();
                    blockConstraintNode.capture(this.environment, child);
                    continue;
                }
                this.throwInternalError(child.getName() + IS_NOT_A_VALID_CHILD_OF + parentName);
            }
            String prop = child.attributeValue(attributeValue);
            if (parentName.equals(PROPERTIES) && !prop.startsWith(COLLECTION) && (m = (p = Pattern.compile("/\\w")).matcher(prop)).find()) {
                prop = COLLECTION + prop;
            }
            IXQEQueryNode node = maProcessor.process(prop, this.nodeFactory);
            if (checkCaseSensitivity) {
                this.setCaseSensitivity(child, node);
            }
            this.addChild(node);
        }
    }

    public void processStrartingConditions(List<Element> children, String parentName, String childName, String attributeName) {
        MAStartAt startAtNode = this.addStartAtNode();
        for (Element child : children) {
            if (!child.getName().equals(childName)) continue;
            startAtNode.capture(this.environment, child);
            startAtNode.setName(parentName);
            startAtNode.setPath(child.attributeValue(attributeName));
        }
    }

    private boolean isBlockConstraint(String parent, String constraint) {
        return parent.equals(CONSTRAINTS) && constraint.equals(BLOCK_CONSTRAINT);
    }

    private void addMandatoryCollections() {
        List<MACollection> collections = this.createFlatCollectionList();
        ArrayList<String> names = new ArrayList<String>();
        for (MACollection collection : collections) {
            names.add(collection.getName());
        }
        if (!names.contains(SHORTCUT)) {
            this.addCollection(SHORTCUT);
        }
        if (!names.contains(PROJECT)) {
            this.addCollection(PROJECT);
        }
        if (names.contains(QUERY_SUBJECT) && !names.contains(DIMENSION)) {
            this.addCollection(DIMENSION);
        }
        if (!names.contains(PACKAGE)) {
            this.addCollection(PACKAGE);
        }
    }

    private void addCollection(String name) {
        MACollection collection = (MACollection)this.nodeFactory.createNode(1101019);
        collection.setName(name);
        collection.setValue(name);
        this.addChild(collection);
    }

    private MABlockConstraint addBlockConstraint() {
        MABlockConstraint blockConstraint = (MABlockConstraint)this.nodeFactory.createNode(1101017);
        this.addChild(blockConstraint);
        return blockConstraint;
    }

    private MAStartAt addStartAtNode() {
        MAStartAt startAt = (MAStartAt)this.nodeFactory.createNode(1101028);
        this.addChild(startAt);
        return startAt;
    }

    private void setCaseSensitivity(Element inputConstraintNode, IXQEQueryNode queryNode) {
        String caseSensitive = inputConstraintNode.attributeValue(CASE_SENSITIVE);
        boolean caseSensitivity = Boolean.valueOf(caseSensitive);
        if (caseSensitive == null) {
            caseSensitivity = true;
        }
        if (queryNode instanceof MAConstraint) {
            MAConstraint constraintNode = (MAConstraint)queryNode;
            constraintNode.setCaseSensitive(caseSensitivity);
        }
    }

    @Override
    public void writeFormattedXML(XMLWriter writer) {
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            child.writeFormattedXML(writer);
        }
    }

    protected List<MACollection> createFlatCollectionList() {
        IXQEQueryNode[] list = this.getChildrenOfType(1101019);
        this.flatCollectionList = new ArrayList<MACollection>();
        for (IXQEQueryNode collection : list) {
            this.flatCollectionList.add((MACollection)collection);
        }
        return this.flatCollectionList;
    }

    public List<MACollection> getCollectionList() {
        if (null == this.flatCollectionList) {
            this.createFlatCollectionList();
        }
        return this.flatCollectionList;
    }

    List<Element> filterGarbageProperties(List<Element> children) {
        ArrayList<Element> filtered = new ArrayList<Element>();
        for (Element child : children) {
            String value = child.attributeValue(NAME);
            if (value != null) {
                if (value.equals("measure/aggregateRule")) continue;
                filtered.add(child);
                continue;
            }
            filtered.add(child);
        }
        return filtered;
    }

    @Override
    public void setMetadataConnection(MetadataConnection ametadataConnection) {
        this.metadataConnection = ametadataConnection;
    }

    @Override
    public MetadataConnection getMetadataConnection() {
        return this.metadataConnection;
    }
}

