/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractBTFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.date.AddSeconds;
import com.cognos.xqe.runtree.XDataContext;
import java.math.BigDecimal;

public class MFAddSeconds
extends MFAbstractBTFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2) {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        String inputTimestamp = null;
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (firstArg instanceof StringValue) {
            inputTimestamp = firstArg.toString();
        } else {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        BigDecimal fractionOfSecondsToAdd = BigDecimal.ZERO;
        IValue secondArg = theFunctionNode.getParameter(theContext, 1);
        if (secondArg instanceof StringValue) {
            fractionOfSecondsToAdd = new BigDecimal(secondArg.toString());
        } else {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        AddSeconds func = new AddSeconds();
        TimestampWithTZValue inputDateTimeTZ = MFAddSeconds.createTimestampWithTZValueFromString(inputTimestamp);
        DecimalValue fractionOfSecondsValue = DataValueFactory.createDecimalValue();
        fractionOfSecondsValue.set(fractionOfSecondsToAdd);
        TimestampWithTZValue outputDateTime = DataValueFactory.createTimestampWithTZValue();
        Value[] args = new Value[2];
        ArgumentList arguments = new ArgumentList();
        arguments.set(args);
        args[0] = inputDateTimeTZ;
        args[1] = fractionOfSecondsValue;
        func.execute(theContext, (IParameterEvaluator)arguments, outputDateTime);
        StringValue resultValue = DataValueFactory.createStringValue();
        resultValue.set(outputDateTime.getStringWithNanoseconds());
        return resultValue;
    }

    @Override
    public String getFunctionName() {
        return "_add_seconds";
    }
}

