/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractBTFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.date.AddYears;
import com.cognos.xqe.runtree.XDataContext;

public class MFAddYears
extends MFAbstractBTFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2) {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        String inputDateOrTimestamp = null;
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (firstArg instanceof StringValue) {
            inputDateOrTimestamp = firstArg.toString();
        } else {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        int numOfYearsToAdd = 0;
        IValue secondArg = theFunctionNode.getParameter(theContext, 1);
        if (secondArg instanceof StringValue) {
            numOfYearsToAdd = theFunctionNode.getInteger((StringValue)secondArg);
        } else {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        IntegerValue numOfYearsValue = DataValueFactory.createIntegerValue();
        numOfYearsValue.set(numOfYearsToAdd);
        AddYears func = new AddYears();
        Value[] args = new Value[2];
        ArgumentList arguments = new ArgumentList();
        arguments.set(args);
        args[1] = numOfYearsValue;
        try {
            if (inputDateOrTimestamp.length() == 10) {
                if (!inputDateOrTimestamp.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d")) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", inputDateOrTimestamp, "date");
                }
                DateValue inputDate = DataValueFactory.createDateValue();
                inputDate.set(inputDateOrTimestamp);
                DateValue outputValue = DataValueFactory.createDateValue();
                args[0] = inputDate;
                func.execute(theContext, (IParameterEvaluator)arguments, outputValue);
                StringValue resultValue = DataValueFactory.createStringValue();
                resultValue.set(outputValue.getString());
                return resultValue;
            }
            TimestampWithTZValue inputDateTimeTZ = DataValueFactory.createTimestampWithTZValue();
            inputDateTimeTZ = MFAddYears.createTimestampWithTZValueFromString(inputDateOrTimestamp);
            TimestampWithTZValue outputValue = DataValueFactory.createTimestampWithTZValue();
            args[0] = inputDateTimeTZ;
            func.execute(theContext, (IParameterEvaluator)arguments, outputValue);
            StringValue resultValue = DataValueFactory.createStringValue();
            resultValue.set(outputValue.getStringWithNanoseconds());
            return resultValue;
        }
        catch (ValueConversionException ve) {
            throw theFunctionNode.getMacroException(ve.getLocalizedMessage());
        }
    }

    @Override
    public String getFunctionName() {
        return "_add_years";
    }
}

