/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MXObject;
import com.cognos.xqe.ast.macro.MXUndefined;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import java.util.List;
import java.util.TreeSet;

public class MFCSVIdentityName
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        boolean minArgsAllowed = true;
        int maxArgsAllowed = 3;
        int numArgs = theFunctionNode.getNumberChildren();
        MXObject hm = null;
        String parameterMapName = null;
        if (numArgs >= 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                parameterMapName = firstArg.toString();
            } else if (firstArg instanceof MXObject) {
                hm = (MXObject)firstArg;
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
        } else {
            this.throwErrorNumberOfArguments(numArgs, 1, 3);
        }
        String separator = ", ";
        if (numArgs >= 2) {
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof StringValue) {
                separator = secondArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(2, secondArg, "string");
            }
        }
        String defaultValue = null;
        if (numArgs >= 3) {
            IValue thirdArg = theFunctionNode.getParameter(theContext, 2);
            if (thirdArg instanceof StringValue) {
                defaultValue = thirdArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(3, thirdArg, "string");
            }
        }
        ParameterAccessCoordinator pac = theContext.getMacroContext().getPAC();
        RequestEnvironment reqEnv = (RequestEnvironment)theContext.getEnvironment().getRequestEnvironment();
        TreeSet<String> uniqueMappings = new TreeSet<String>();
        List<ICMSessionIdentity> identities = ContentManager.getUserDefaultIdentityNames(reqEnv);
        for (ICMSessionIdentity cmIdentity : identities) {
            String defaultName = cmIdentity.getDefaultName();
            String value = null;
            if (hm != null) {
                IValue mappedValue = hm.get(defaultName);
                if (!(mappedValue instanceof MXUndefined)) {
                    value = mappedValue.toString();
                }
            } else {
                value = pac.get(parameterMapName, defaultName, false);
            }
            if (value == null || value.length() <= 0) continue;
            uniqueMappings.add(value);
        }
        if (uniqueMappings.isEmpty()) {
            if (defaultValue == null && hm == null) {
                defaultValue = pac.getDefault(parameterMapName);
            }
            if (defaultValue != null && defaultValue.length() > 0) {
                uniqueMappings.add(defaultValue);
            }
        }
        StringBuilder answerBuf = new StringBuilder();
        String singleQuote = "'";
        for (String value : uniqueMappings) {
            String escapedValue = value.replaceAll("'", "''");
            if (answerBuf.length() > 0) {
                answerBuf.append(separator);
            }
            answerBuf.append("'");
            answerBuf.append(escapedValue);
            answerBuf.append("'");
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(answerBuf.toString());
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "CSVIdentityName";
    }
}

